/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import javax.cache.Cache;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.jcache.AbstractJCache;
import org.infinispan.jcache.AbstractJCacheListenerAdapter;
import org.infinispan.jcache.JCacheEventFilteringIterable;
import org.infinispan.jcache.RICacheEntryEvent;
import org.infinispan.jcache.logging.Log;

public abstract class AbstractJCacheNotifier<K, V> {
    private static final Log log = LogFactory.getLog(AbstractJCacheNotifier.class, Log.class);
    private static final boolean isTrace = log.isTraceEnabled();
    private final List<CacheEntryCreatedListener<K, V>> createdListeners = new CopyOnWriteArrayList<CacheEntryCreatedListener<K, V>>();
    private final List<CacheEntryUpdatedListener<K, V>> updatedListeners = new CopyOnWriteArrayList<CacheEntryUpdatedListener<K, V>>();
    private final List<CacheEntryRemovedListener<K, V>> removedListeners = new CopyOnWriteArrayList<CacheEntryRemovedListener<K, V>>();
    private final List<CacheEntryExpiredListener<K, V>> expiredListeners = new CopyOnWriteArrayList<CacheEntryExpiredListener<K, V>>();
    private final ConcurrentMap<CacheEntryListener<? super K, ? super V>, CacheEntryListenerConfiguration<K, V>> listenerCfgs = CollectionFactory.makeConcurrentMap();
    private AbstractJCacheListenerAdapter<K, V> listenerAdapter;
    private ConcurrentMap<EventSource<K, V>, Queue<CountDownLatch>> latchesByEventSource = new ConcurrentHashMap<EventSource<K, V>, Queue<CountDownLatch>>();

    public void addListener(CacheEntryListenerConfiguration<K, V> reg, AbstractJCache<K, V> jcache, AbstractJCacheNotifier<K, V> notifier) {
        boolean addListenerAdapter = this.listenerCfgs.isEmpty();
        this.addListener(reg, false);
        if (addListenerAdapter) {
            this.listenerAdapter = this.createListenerAdapter(jcache, notifier);
            jcache.addListener(this.listenerAdapter);
        }
    }

    public void removeListener(CacheEntryListenerConfiguration<K, V> reg, AbstractJCache<K, V> jcache) {
        this.removeListener(reg);
        if (this.listenerCfgs.isEmpty()) {
            jcache.removeListener(this.listenerAdapter);
        }
    }

    public void addSyncNotificationLatch(Cache<K, V> cache, K key, V value, CountDownLatch latch) {
        EventSource<K, V> eventSourceKey = new EventSource<K, V>(cache, key, value);
        this.latchesByEventSource.computeIfAbsent(eventSourceKey, kvEventSource -> new ConcurrentLinkedQueue()).add(latch);
    }

    public void removeSyncNotificationLatch(Cache<K, V> cache, K key, V value, CountDownLatch latch) {
        EventSource<K, V> eventSourceKey = new EventSource<K, V>(cache, key, value);
        Queue latches = (Queue)this.latchesByEventSource.get(eventSourceKey);
        if (latches == null) {
            return;
        }
        this.latchesByEventSource.compute(eventSourceKey, (kvEventSource, countDownLatches) -> {
            countDownLatches.remove(latch);
            return countDownLatches.isEmpty() ? null : countDownLatches;
        });
    }

    private void notifySync(Cache<K, V> cache, K key, V value) {
        EventSource<K, V> eventSourceKey = new EventSource<K, V>(cache, key, value);
        this.notifySync((Queue)this.latchesByEventSource.get(eventSourceKey));
    }

    private void notifySync(Queue<CountDownLatch> latches) {
        if (latches == null) {
            return;
        }
        CountDownLatch latch = latches.poll();
        if (latch != null) {
            latch.countDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEntryCreated(Cache<K, V> cache, K key, V value) {
        try {
            if (!this.createdListeners.isEmpty()) {
                List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.CREATED);
                for (CacheEntryCreatedListener<K, V> listener : this.createdListeners) {
                    listener.onCreated(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
                }
            }
        }
        finally {
            this.notifySync(cache, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEntryUpdated(Cache<K, V> cache, K key, V value) {
        try {
            if (!this.updatedListeners.isEmpty()) {
                List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.UPDATED);
                for (CacheEntryUpdatedListener<K, V> listener : this.updatedListeners) {
                    listener.onUpdated(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
                }
            }
        }
        finally {
            this.notifySync(cache, key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEntryRemoved(Cache<K, V> cache, K key, V value) {
        try {
            if (!this.removedListeners.isEmpty()) {
                List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.REMOVED);
                for (CacheEntryRemovedListener<K, V> listener : this.removedListeners) {
                    listener.onRemoved(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
                }
            }
        }
        finally {
            this.notifySync(cache, key, null);
        }
    }

    public void notifyEntryExpired(Cache<K, V> cache, K key, V value) {
        if (!this.expiredListeners.isEmpty()) {
            List<CacheEntryEvent<? extends K, ? extends V>> events = this.createEvent(cache, key, value, EventType.EXPIRED);
            for (CacheEntryExpiredListener<K, V> listener : this.expiredListeners) {
                listener.onExpired(this.getEntryIterable(events, (CacheEntryListenerConfiguration)this.listenerCfgs.get(listener)));
            }
        }
    }

    public boolean hasSyncCreatedListener() {
        return this.hasSyncListener(CacheEntryCreatedListener.class);
    }

    public boolean hasSyncRemovedListener() {
        return this.hasSyncListener(CacheEntryRemovedListener.class);
    }

    public boolean hasSyncUpdatedListener() {
        return this.hasSyncListener(CacheEntryUpdatedListener.class);
    }

    private boolean hasSyncListener(Class<?> listenerClass) {
        for (Map.Entry entry : this.listenerCfgs.entrySet()) {
            if (!((CacheEntryListenerConfiguration)entry.getValue()).isSynchronous() || !listenerClass.isInstance(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private Iterable<CacheEntryEvent<? extends K, ? extends V>> getEntryIterable(List<CacheEntryEvent<? extends K, ? extends V>> events, CacheEntryListenerConfiguration<K, V> listenerCfg) {
        Factory factory = listenerCfg.getCacheEntryEventFilterFactory();
        if (factory != null) {
            CacheEntryEventFilter filter = (CacheEntryEventFilter)factory.create();
            return filter == null ? events : new JCacheEventFilteringIterable<K, V>(events, filter);
        }
        return events;
    }

    private boolean addListener(CacheEntryListenerConfiguration<K, V> listenerCfg, boolean addIfAbsent) {
        boolean added = false;
        CacheEntryListener listener = (CacheEntryListener)listenerCfg.getCacheEntryListenerFactory().create();
        if (listener instanceof CacheEntryCreatedListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.createdListeners) && this.createdListeners.add((CacheEntryCreatedListener)listener);
        }
        if (listener instanceof CacheEntryUpdatedListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.updatedListeners) && this.updatedListeners.add((CacheEntryUpdatedListener)listener);
        }
        if (listener instanceof CacheEntryRemovedListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.removedListeners) && this.removedListeners.add((CacheEntryRemovedListener)listener);
        }
        if (listener instanceof CacheEntryExpiredListener) {
            boolean bl = added = !this.containsListener(addIfAbsent, listener, this.expiredListeners) && this.expiredListeners.add((CacheEntryExpiredListener)listener);
        }
        if (added) {
            this.listenerCfgs.put(listener, listenerCfg);
        }
        return added;
    }

    private boolean containsListener(boolean addIfAbsent, CacheEntryListener<? super K, ? super V> listenerToAdd, List<? extends CacheEntryListener<? super K, ? super V>> listeners) {
        if (addIfAbsent) {
            for (CacheEntryListener<K, V> listener : listeners) {
                if (!listener.equals(listenerToAdd)) continue;
                return true;
            }
        }
        return false;
    }

    private void removeListener(CacheEntryListenerConfiguration<K, V> listenerCfg) {
        for (Map.Entry entry : this.listenerCfgs.entrySet()) {
            CacheEntryListenerConfiguration cfg = (CacheEntryListenerConfiguration)entry.getValue();
            if (!cfg.equals(listenerCfg)) continue;
            CacheEntryListener listener = (CacheEntryListener)entry.getKey();
            if (listener instanceof CacheEntryCreatedListener) {
                this.createdListeners.remove(listener);
            }
            if (listener instanceof CacheEntryUpdatedListener) {
                this.updatedListeners.remove(listener);
            }
            if (listener instanceof CacheEntryRemovedListener) {
                this.removedListeners.remove(listener);
            }
            if (!(listener instanceof CacheEntryExpiredListener)) continue;
            this.expiredListeners.remove(listener);
        }
    }

    private List<CacheEntryEvent<? extends K, ? extends V>> createEvent(Cache<K, V> cache, K key, V value, EventType eventType) {
        List<CacheEntryEvent<? extends K, ? extends V>> events = Collections.singletonList(new RICacheEntryEvent<K, V>(cache, key, value, eventType));
        if (isTrace) {
            log.tracef("Received event: %s", (Object)events);
        }
        return events;
    }

    protected abstract AbstractJCacheListenerAdapter<K, V> createListenerAdapter(AbstractJCache<K, V> var1, AbstractJCacheNotifier<K, V> var2);

    private static class EventSource<K, V> {
        private final Cache<K, V> cache;
        private final K key;
        private final V value;

        public EventSource(Cache<K, V> cache, K key, V value) {
            this.cache = cache;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EventSource)) {
                return false;
            }
            EventSource otherEventSource = (EventSource)obj;
            return EventSource.equalOrNull(this.cache, otherEventSource.cache) && EventSource.equalOrNull(this.key, otherEventSource.key) && EventSource.equalOrNull(this.value, otherEventSource.value);
        }

        private static boolean equalOrNull(Object obj1, Object obj2) {
            return obj1 == null && obj2 == null || obj1 != null && obj1.equals(obj2);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.cache == null ? 0 : this.cache.hashCode());
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }
    }
}

