/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol;

import infinispan.org.jboss.as.protocol.GeneralTimeoutHandler;
import infinispan.org.jboss.as.protocol.ProtocolConnectionConfiguration;
import infinispan.org.jboss.as.protocol.ProtocolTimeoutHandler;
import infinispan.org.jboss.as.protocol.logging.ProtocolLogger;
import infinispan.org.jboss.remoting3.Connection;
import infinispan.org.jboss.remoting3.Endpoint;
import infinispan.org.jboss.remoting3.RemotingOptions;
import infinispan.org.xnio.IoFuture;
import infinispan.org.xnio.OptionMap;
import infinispan.org.xnio.Options;
import infinispan.org.xnio.Property;
import infinispan.org.xnio.Sequence;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class ProtocolConnectionUtils {
    private static final String JBOSS_LOCAL_USER = "JBOSS-LOCAL-USER";

    public static IoFuture<Connection> connect(ProtocolConnectionConfiguration configuration) throws IOException {
        return ProtocolConnectionUtils.connect(configuration.getCallbackHandler(), configuration);
    }

    private static IoFuture<Connection> connect(CallbackHandler handler, ProtocolConnectionConfiguration configuration) throws IOException {
        Endpoint endpoint = configuration.getEndpoint();
        OptionMap options = ProtocolConnectionUtils.getOptions(configuration);
        CallbackHandler actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        String clientBindAddress = configuration.getClientBindAddress();
        if (clientBindAddress == null) {
            return endpoint.connect(configuration.getUri(), options, actualHandler, configuration.getSslContext());
        }
        InetSocketAddress bindAddr = new InetSocketAddress(clientBindAddress, 0);
        InetSocketAddress destAddr = new InetSocketAddress(configuration.getUri().getHost(), configuration.getUri().getPort());
        return endpoint.connect(configuration.getUri().getScheme(), (SocketAddress)bindAddr, (SocketAddress)destAddr, options, actualHandler, configuration.getSslContext());
    }

    public static Connection connectSync(ProtocolConnectionConfiguration configuration) throws IOException {
        CallbackHandler actualHandler;
        long timeoutMillis = configuration.getConnectionTimeout();
        CallbackHandler handler = configuration.getCallbackHandler();
        ProtocolTimeoutHandler timeoutHandler = configuration.getTimeoutHandler();
        if (timeoutHandler == null) {
            GeneralTimeoutHandler defaultTimeoutHandler = new GeneralTimeoutHandler();
            actualHandler = handler != null ? new WrapperCallbackHandler(defaultTimeoutHandler, handler) : new AnonymousCallbackHandler();
            timeoutHandler = defaultTimeoutHandler;
        } else {
            actualHandler = handler != null ? handler : new AnonymousCallbackHandler();
        }
        IoFuture<Connection> future = ProtocolConnectionUtils.connect(actualHandler, configuration);
        IoFuture.Status status = timeoutHandler.await(future, timeoutMillis);
        if (status == IoFuture.Status.DONE) {
            return future.get();
        }
        if (status == IoFuture.Status.FAILED) {
            throw ProtocolLogger.ROOT_LOGGER.failedToConnect(configuration.getUri(), future.getException());
        }
        throw ProtocolLogger.ROOT_LOGGER.couldNotConnect(configuration.getUri());
    }

    private static OptionMap getOptions(ProtocolConnectionConfiguration configuration) {
        Map<String, String> saslOptions = configuration.getSaslOptions();
        OptionMap.Builder builder = OptionMap.builder();
        builder.set(Options.SASL_POLICY_NOANONYMOUS, Boolean.FALSE);
        builder.set(Options.SASL_POLICY_NOPLAINTEXT, Boolean.FALSE);
        builder.addAll(configuration.getOptionMap());
        ProtocolConnectionUtils.configureSaslMechnisms(saslOptions, ProtocolConnectionUtils.isLocal(configuration.getUri()), builder);
        ArrayList<Property> tempProperties = new ArrayList<Property>(saslOptions != null ? saslOptions.size() : 1);
        tempProperties.add(Property.of("jboss.sasl.local-user.quiet-auth", "true"));
        if (saslOptions != null) {
            for (String currentKey : saslOptions.keySet()) {
                tempProperties.add(Property.of(currentKey, saslOptions.get(currentKey)));
            }
        }
        builder.set(Options.SASL_PROPERTIES, Sequence.of(tempProperties));
        builder.set(Options.SSL_ENABLED, configuration.isSslEnabled());
        builder.set(Options.SSL_STARTTLS, configuration.isUseStartTLS());
        builder.set(RemotingOptions.SASL_PROTOCOL, "remote");
        return builder.getMap();
    }

    private static void configureSaslMechnisms(Map<String, String> saslOptions, boolean isLocal, OptionMap.Builder builder) {
        String[] split;
        String listed;
        String[] mechanisms = null;
        if (saslOptions != null && (listed = saslOptions.get(Options.SASL_DISALLOWED_MECHANISMS.getName())) != null) {
            split = listed.split(" ");
            if (isLocal) {
                mechanisms = new String[split.length + 1];
                mechanisms[0] = JBOSS_LOCAL_USER;
                System.arraycopy(split, 0, mechanisms, 1, split.length);
            } else {
                mechanisms = split;
            }
        } else if (!isLocal) {
            mechanisms = new String[]{JBOSS_LOCAL_USER};
        }
        if (mechanisms != null) {
            builder.set(Options.SASL_DISALLOWED_MECHANISMS, Sequence.of(mechanisms));
        }
        if (saslOptions != null && (listed = saslOptions.get(Options.SASL_MECHANISMS.getName())) != null && (split = listed.split(" ")).length > 0) {
            builder.set(Options.SASL_MECHANISMS, Sequence.of(split));
        }
    }

    private static boolean isLocal(URI uri) {
        try {
            NetworkInterface nic;
            String hostName = uri.getHost();
            InetAddress address = InetAddress.getByName(hostName);
            if (address.isLinkLocalAddress()) {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                nic = null;
                while (interfaces.hasMoreElements() && nic == null) {
                    NetworkInterface current = interfaces.nextElement();
                    Enumeration<InetAddress> addresses = current.getInetAddresses();
                    while (addresses.hasMoreElements() && nic == null) {
                        InetAddress currentAddress = addresses.nextElement();
                        if (!address.equals(currentAddress)) continue;
                        nic = current;
                    }
                }
            } else {
                nic = NetworkInterface.getByInetAddress(address);
            }
            return address.isLoopbackAddress() || nic != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final class AnonymousCallbackHandler
    implements CallbackHandler {
        private AnonymousCallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }

    private static final class WrapperCallbackHandler
    implements CallbackHandler {
        private final GeneralTimeoutHandler timeoutHandler;
        private final CallbackHandler wrapped;

        WrapperCallbackHandler(GeneralTimeoutHandler timeoutHandler, CallbackHandler toWrap) {
            this.timeoutHandler = timeoutHandler;
            this.wrapped = toWrap;
        }

        @Override
        public void handle(final Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            try {
                this.timeoutHandler.suspendAndExecute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            WrapperCallbackHandler.this.wrapped.handle(callbacks);
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        catch (UnsupportedCallbackException e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                if (e.getCause() instanceof UnsupportedCallbackException) {
                    throw (UnsupportedCallbackException)e.getCause();
                }
                throw e;
            }
        }
    }
}

