/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.channels;

import infinispan.org.xnio.ChannelListener;
import infinispan.org.xnio.ChannelListeners;
import infinispan.org.xnio.Option;
import infinispan.org.xnio.XnioExecutor;
import infinispan.org.xnio.XnioIoThread;
import infinispan.org.xnio.XnioWorker;
import infinispan.org.xnio._private.Messages;
import infinispan.org.xnio.channels.AssembledChannel;
import infinispan.org.xnio.channels.CloseableChannel;
import infinispan.org.xnio.channels.StreamChannel;
import infinispan.org.xnio.channels.StreamSinkChannel;
import infinispan.org.xnio.channels.StreamSourceChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;

public class AssembledStreamChannel
implements StreamChannel {
    private final CloseableChannel closeable;
    private final StreamSourceChannel source;
    private final StreamSinkChannel sink;
    private final ChannelListener.Setter<AssembledStreamChannel> readSetter;
    private final ChannelListener.Setter<AssembledStreamChannel> writeSetter;
    private final ChannelListener.Setter<AssembledStreamChannel> closeSetter;

    public AssembledStreamChannel(CloseableChannel closeable, StreamSourceChannel source, StreamSinkChannel sink) {
        if (source.getWorker() != sink.getWorker() || source.getWorker() != closeable.getWorker()) {
            throw Messages.msg.differentWorkers();
        }
        this.closeable = closeable;
        this.source = source;
        this.sink = sink;
        this.readSetter = ChannelListeners.getDelegatingSetter(source.getReadSetter(), this);
        this.writeSetter = ChannelListeners.getDelegatingSetter(sink.getWriteSetter(), this);
        this.closeSetter = ChannelListeners.getDelegatingSetter(closeable.getCloseSetter(), this);
    }

    public AssembledStreamChannel(StreamSourceChannel source, StreamSinkChannel sink) {
        this(new AssembledChannel(source, sink), source, sink);
    }

    public ChannelListener.Setter<? extends AssembledStreamChannel> getReadSetter() {
        return this.readSetter;
    }

    @Override
    public void suspendReads() {
        this.source.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.source.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.source.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.source.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.source.shutdownReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.source.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.source.awaitReadable(time, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.source.getReadThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.source.getIoThread();
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        return this.source.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.source.read(dsts, offset, length);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        return this.source.read(dsts);
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        return this.source.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        return this.source.transferTo(count, throughBuffer, target);
    }

    @Override
    public long transferFrom(FileChannel src, long position, long count) throws IOException {
        return this.sink.transferFrom(src, position, count);
    }

    @Override
    public long transferFrom(StreamSourceChannel source, long count, ByteBuffer throughBuffer) throws IOException {
        return this.sink.transferFrom(source, count, throughBuffer);
    }

    public ChannelListener.Setter<? extends AssembledStreamChannel> getWriteSetter() {
        return this.writeSetter;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.sink.write(src);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.sink.write(srcs, offset, length);
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.sink.write(srcs);
    }

    @Override
    public void suspendWrites() {
        this.sink.suspendWrites();
    }

    @Override
    public void resumeWrites() {
        this.sink.resumeWrites();
    }

    @Override
    public boolean isWriteResumed() {
        return this.sink.isWriteResumed();
    }

    @Override
    public void wakeupWrites() {
        this.sink.wakeupWrites();
    }

    @Override
    public void shutdownWrites() throws IOException {
        this.sink.shutdownWrites();
    }

    @Override
    public void awaitWritable() throws IOException {
        this.sink.awaitWritable();
    }

    @Override
    public void awaitWritable(long time, TimeUnit timeUnit) throws IOException {
        this.sink.awaitWritable(time, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getWriteThread() {
        return this.sink.getWriteThread();
    }

    @Override
    public boolean flush() throws IOException {
        return this.sink.flush();
    }

    public ChannelListener.Setter<? extends AssembledStreamChannel> getCloseSetter() {
        return this.closeSetter;
    }

    @Override
    public int writeFinal(ByteBuffer src) throws IOException {
        return this.sink.writeFinal(src);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs, int offset, int length) throws IOException {
        return this.sink.writeFinal(srcs, offset, length);
    }

    @Override
    public long writeFinal(ByteBuffer[] srcs) throws IOException {
        return this.sink.writeFinal(srcs);
    }

    @Override
    public XnioWorker getWorker() {
        return this.closeable.getWorker();
    }

    @Override
    public void close() throws IOException {
        this.closeable.close();
    }

    @Override
    public boolean isOpen() {
        return this.closeable.isOpen();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.closeable.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.closeable.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.closeable.setOption(option, value);
    }
}

