/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.channels;

import infinispan.org.xnio.Buffers;
import infinispan.org.xnio.ChannelListener;
import infinispan.org.xnio.ChannelListeners;
import infinispan.org.xnio.Option;
import infinispan.org.xnio.Pooled;
import infinispan.org.xnio.XnioExecutor;
import infinispan.org.xnio.XnioIoThread;
import infinispan.org.xnio.XnioWorker;
import infinispan.org.xnio.channels.StreamSinkChannel;
import infinispan.org.xnio.channels.StreamSourceChannel;
import infinispan.org.xnio.channels.WrappedChannel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;

public final class PushBackStreamChannel
implements StreamSourceChannel,
WrappedChannel<StreamSourceChannel> {
    private final StreamSourceChannel firstChannel;
    private StreamSourceChannel channel;
    private ChannelListener<? super PushBackStreamChannel> readListener;
    private ChannelListener<? super PushBackStreamChannel> closeListener;

    public PushBackStreamChannel(StreamSourceChannel channel) {
        this.channel = this.firstChannel = channel;
        this.firstChannel.getReadSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                ChannelListeners.invokeChannelListener(PushBackStreamChannel.this, PushBackStreamChannel.this.readListener);
            }
        });
        this.firstChannel.getCloseSetter().set((ChannelListener<? extends StreamSourceChannel>)new ChannelListener<StreamSourceChannel>(){

            @Override
            public void handleEvent(StreamSourceChannel channel) {
                ChannelListeners.invokeChannelListener(PushBackStreamChannel.this, PushBackStreamChannel.this.closeListener);
            }
        });
    }

    public void setReadListener(ChannelListener<? super PushBackStreamChannel> readListener) {
        this.readListener = readListener;
    }

    public void setCloseListener(ChannelListener<? super PushBackStreamChannel> closeListener) {
        this.closeListener = closeListener;
    }

    public ChannelListener.Setter<? extends PushBackStreamChannel> getReadSetter() {
        return new ChannelListener.Setter<PushBackStreamChannel>(){

            @Override
            public void set(ChannelListener<? super PushBackStreamChannel> listener) {
                PushBackStreamChannel.this.setReadListener(listener);
            }
        };
    }

    public ChannelListener.Setter<? extends PushBackStreamChannel> getCloseSetter() {
        return new ChannelListener.Setter<PushBackStreamChannel>(){

            @Override
            public void set(ChannelListener<? super PushBackStreamChannel> listener) {
                PushBackStreamChannel.this.setCloseListener(listener);
            }
        };
    }

    @Override
    public long transferTo(long position, long count, FileChannel target) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return 0L;
        }
        return channel.transferTo(position, count, target);
    }

    @Override
    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return -1L;
        }
        return channel.transferTo(count, throughBuffer, target);
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return -1;
        }
        return channel.read(dst);
    }

    @Override
    public long read(ByteBuffer[] dsts) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return -1L;
        }
        return channel.read(dsts);
    }

    @Override
    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel == null) {
            return -1L;
        }
        return channel.read(dsts, offset, length);
    }

    public void unget(Pooled<ByteBuffer> buffer) {
        StreamSourceChannel old = this.channel;
        if (old == null) {
            buffer.free();
            return;
        }
        this.channel = new BufferHolder(old, buffer);
    }

    @Override
    public void suspendReads() {
        this.firstChannel.suspendReads();
    }

    @Override
    public void resumeReads() {
        StreamSourceChannel channel = this.channel;
        if (channel != null) {
            channel.resumeReads();
        }
    }

    @Override
    public boolean isReadResumed() {
        return this.firstChannel.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.firstChannel.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        StreamSourceChannel old = this.channel;
        if (old != null) {
            this.channel = null;
            old.shutdownReads();
        }
    }

    @Override
    public void awaitReadable() throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel != null) {
            channel.awaitReadable();
        }
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        StreamSourceChannel channel = this.channel;
        if (channel != null) {
            channel.awaitReadable(time, timeUnit);
        }
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.firstChannel.getReadThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.firstChannel.getIoThread();
    }

    @Override
    public XnioWorker getWorker() {
        return this.firstChannel.getWorker();
    }

    @Override
    public boolean isOpen() {
        return this.firstChannel.isOpen();
    }

    @Override
    public void close() throws IOException {
        StreamSourceChannel old = this.channel;
        if (old != null) {
            this.channel = null;
            old.close();
        }
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.firstChannel.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.firstChannel.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.firstChannel.setOption(option, value);
    }

    @Override
    public StreamSourceChannel getChannel() {
        return this.firstChannel;
    }

    class BufferHolder
    implements StreamSourceChannel {
        private final StreamSourceChannel next;
        private final Pooled<ByteBuffer> buffer;

        BufferHolder(StreamSourceChannel next, Pooled<ByteBuffer> buffer) {
            this.next = next;
            this.buffer = buffer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long transferTo(long position, long count, FileChannel target) throws IOException {
            long cnt;
            try {
                ByteBuffer src = this.buffer.getResource();
                int pos = src.position();
                int rem = src.remaining();
                if ((long)rem <= count) {
                    cnt = target.write(src, position);
                    if (cnt != (long)rem) return cnt;
                    PushBackStreamChannel.this.channel = this.next;
                    this.buffer.free();
                    return cnt + this.next.transferTo(position += cnt, count -= cnt, target);
                }
                try {
                    src.limit(pos + (int)count);
                    long l = target.write(src, position);
                    return l;
                }
                finally {
                    src.limit(pos + rem);
                }
            }
            catch (IllegalStateException ignored) {
                PushBackStreamChannel.this.channel = this.next;
                cnt = 0L;
            }
            return cnt + this.next.transferTo(position, count, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
            long l;
            long cnt;
            throughBuffer.clear();
            try {
                ByteBuffer src = this.buffer.getResource();
                int pos = src.position();
                int rem = src.remaining();
                if ((long)rem > count) {
                    try {
                        src.limit(pos + (int)count);
                        throughBuffer.limit(0);
                        long l2 = target.write(src);
                        return l2;
                    }
                    finally {
                        src.limit(pos + rem);
                    }
                }
                cnt = target.write(src);
                if (cnt != (long)rem) return cnt;
                PushBackStreamChannel.this.channel = this.next;
                this.buffer.free();
            }
            catch (IllegalStateException ignored) {
                PushBackStreamChannel.this.channel = this.next;
                cnt = 0L;
            }
            long res = this.next.transferTo(count - cnt, throughBuffer, target);
            if (res > 0L) {
                l = cnt + res;
                return l;
            }
            if (cnt > 0L) {
                l = cnt;
                return l;
            }
            l = res;
            return l;
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            long cnt;
            try {
                ByteBuffer src = this.buffer.getResource();
                cnt = Buffers.copy(dsts, offset, length, src);
                if (src.hasRemaining()) {
                    return cnt;
                }
                StreamSourceChannel next = PushBackStreamChannel.this.channel = this.next;
                this.buffer.free();
                if (cnt > 0L && next == PushBackStreamChannel.this.firstChannel) {
                    return cnt;
                }
            }
            catch (IllegalStateException ignored) {
                PushBackStreamChannel.this.channel = this.next;
                cnt = 0L;
            }
            long res = this.next.read(dsts, offset, length);
            return res > 0L ? res + cnt : (cnt > 0L ? cnt : res);
        }

        @Override
        public long read(ByteBuffer[] dsts) throws IOException {
            return this.read(dsts, 0, dsts.length);
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            int cnt;
            if (!dst.hasRemaining()) {
                return 0;
            }
            try {
                ByteBuffer src = this.buffer.getResource();
                cnt = Buffers.copy(dst, src);
                if (src.hasRemaining()) {
                    return cnt;
                }
                StreamSourceChannel next = PushBackStreamChannel.this.channel = this.next;
                this.buffer.free();
                if (cnt > 0 && next == PushBackStreamChannel.this.firstChannel) {
                    return cnt;
                }
            }
            catch (IllegalStateException ignored) {
                PushBackStreamChannel.this.channel = this.next;
                cnt = 0;
            }
            int res = this.next.read(dst);
            return res > 0 ? res + cnt : (cnt > 0 ? cnt : res);
        }

        @Override
        public void close() throws IOException {
            this.buffer.free();
            this.next.close();
        }

        @Override
        public void resumeReads() {
            PushBackStreamChannel.this.firstChannel.wakeupReads();
        }

        @Override
        public void shutdownReads() throws IOException {
            this.buffer.free();
            this.next.shutdownReads();
        }

        @Override
        public void awaitReadable() throws IOException {
        }

        @Override
        public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        }

        @Override
        public boolean isOpen() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelListener.Setter<? extends StreamSourceChannel> getReadSetter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelListener.Setter<? extends StreamSourceChannel> getCloseSetter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void suspendReads() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isReadResumed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void wakeupReads() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Deprecated
        public XnioExecutor getReadThread() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XnioIoThread getIoThread() {
            throw new UnsupportedOperationException();
        }

        @Override
        public XnioWorker getWorker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportsOption(Option<?> option) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T getOption(Option<T> option) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
            throw new UnsupportedOperationException();
        }
    }
}

