/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.conduits;

import infinispan.org.xnio.ChannelListener;
import infinispan.org.xnio.Option;
import infinispan.org.xnio.XnioExecutor;
import infinispan.org.xnio.XnioIoThread;
import infinispan.org.xnio.XnioWorker;
import infinispan.org.xnio.channels.CloseListenerSettable;
import infinispan.org.xnio.channels.Configurable;
import infinispan.org.xnio.channels.ReadListenerSettable;
import infinispan.org.xnio.channels.ReadableMessageChannel;
import infinispan.org.xnio.conduits.MessageSourceConduit;
import infinispan.org.xnio.conduits.ReadReadyHandler;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

public final class ConduitReadableMessageChannel
implements ReadableMessageChannel,
ReadListenerSettable<ConduitReadableMessageChannel>,
CloseListenerSettable<ConduitReadableMessageChannel>,
Cloneable {
    private final Configurable configurable;
    private MessageSourceConduit conduit;
    private ChannelListener<? super ConduitReadableMessageChannel> readListener;
    private ChannelListener<? super ConduitReadableMessageChannel> closeListener;

    public ConduitReadableMessageChannel(Configurable configurable, MessageSourceConduit conduit) {
        this.configurable = configurable;
        this.conduit = conduit;
        conduit.setReadReadyHandler(new ReadReadyHandler.ChannelListenerHandler<ConduitReadableMessageChannel>(this));
    }

    public MessageSourceConduit getConduit() {
        return this.conduit;
    }

    public void setConduit(MessageSourceConduit conduit) {
        this.conduit = conduit;
    }

    @Override
    public boolean isOpen() {
        return !this.conduit.isReadShutdown();
    }

    @Override
    public void setReadListener(ChannelListener<? super ConduitReadableMessageChannel> readListener) {
        this.readListener = readListener;
    }

    @Override
    public ChannelListener<? super ConduitReadableMessageChannel> getReadListener() {
        return this.readListener;
    }

    @Override
    public void setCloseListener(ChannelListener<? super ConduitReadableMessageChannel> closeListener) {
        this.closeListener = closeListener;
    }

    @Override
    public ChannelListener<? super ConduitReadableMessageChannel> getCloseListener() {
        return this.closeListener;
    }

    public ChannelListener.Setter<ConduitReadableMessageChannel> getReadSetter() {
        return new ReadListenerSettable.Setter<ConduitReadableMessageChannel>(this);
    }

    public ChannelListener.Setter<ConduitReadableMessageChannel> getCloseSetter() {
        return new CloseListenerSettable.Setter<ConduitReadableMessageChannel>(this);
    }

    @Override
    public XnioWorker getWorker() {
        return this.conduit.getWorker();
    }

    @Override
    public long receive(ByteBuffer[] dsts, int offset, int length) throws IOException {
        return this.conduit.receive(dsts, offset, length);
    }

    @Override
    public long receive(ByteBuffer[] dsts) throws IOException {
        return this.conduit.receive(dsts, 0, dsts.length);
    }

    @Override
    public int receive(ByteBuffer dst) throws IOException {
        return this.conduit.receive(dst);
    }

    @Override
    public void suspendReads() {
        this.conduit.suspendReads();
    }

    @Override
    public void resumeReads() {
        this.conduit.resumeReads();
    }

    @Override
    public boolean isReadResumed() {
        return this.conduit.isReadResumed();
    }

    @Override
    public void wakeupReads() {
        this.conduit.wakeupReads();
    }

    @Override
    public void shutdownReads() throws IOException {
        this.conduit.terminateReads();
    }

    @Override
    public void awaitReadable() throws IOException {
        this.conduit.awaitReadable();
    }

    @Override
    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        this.conduit.awaitReadable(time, timeUnit);
    }

    @Override
    @Deprecated
    public XnioExecutor getReadThread() {
        return this.conduit.getReadThread();
    }

    @Override
    public XnioIoThread getIoThread() {
        return this.conduit.getReadThread();
    }

    @Override
    public void close() throws IOException {
        this.conduit.terminateReads();
    }

    @Override
    public boolean supportsOption(Option<?> option) {
        return this.configurable.supportsOption(option);
    }

    @Override
    public <T> T getOption(Option<T> option) throws IOException {
        return this.configurable.getOption(option);
    }

    @Override
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        return this.configurable.setOption(option, value);
    }

    public ConduitReadableMessageChannel clone() {
        try {
            return (ConduitReadableMessageChannel)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

