/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.xnio.nio;

import infinispan.org.xnio.Bits;
import infinispan.org.xnio.nio.WorkerThread;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;

abstract class NioHandle {
    private final WorkerThread workerThread;
    private final SelectionKey selectionKey;

    protected NioHandle(WorkerThread workerThread, SelectionKey selectionKey) {
        this.workerThread = workerThread;
        this.selectionKey = selectionKey;
    }

    void resume(int ops) {
        try {
            if (!Bits.allAreSet(this.selectionKey.interestOps(), ops)) {
                this.workerThread.setOps(this.selectionKey, ops);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    void wakeup(final int ops) {
        this.workerThread.queueTask(new Runnable(){

            @Override
            public void run() {
                NioHandle.this.handleReady(ops);
            }
        });
        try {
            if (!Bits.allAreSet(this.selectionKey.interestOps(), ops)) {
                this.workerThread.setOps(this.selectionKey, ops);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    void suspend(int ops) {
        try {
            if (!Bits.allAreClear(this.selectionKey.interestOps(), ops)) {
                this.workerThread.clearOps(this.selectionKey, ops);
            }
        }
        catch (CancelledKeyException cancelledKeyException) {
            // empty catch block
        }
    }

    boolean isResumed(int ops) {
        try {
            return Bits.allAreSet(this.selectionKey.interestOps(), ops);
        }
        catch (CancelledKeyException ignored) {
            return false;
        }
    }

    abstract void handleReady(int var1);

    abstract void forceTermination();

    abstract void terminated();

    WorkerThread getWorkerThread() {
        return this.workerThread;
    }

    SelectionKey getSelectionKey() {
        return this.selectionKey;
    }
}

