/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.core.security.AccessMechanism;
import infinispan.org.jboss.dmr.ModelNode;
import java.net.InetAddress;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.List;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;

public interface ConfigurationChangesCollector {
    public static final ConfigurationChangesCollectorImpl INSTANCE = new ConfigurationChangesCollectorImpl(0);

    public void addConfigurationChanges(ConfigurationChange var1);

    public List<ModelNode> getChanges();

    public void setMaxHistory(int var1);

    public boolean trackAllowed();

    public void deactivate();

    public static final class ConfigurationChange
    implements Comparable<ConfigurationChange> {
        private static final DateTimeFormatter DATE_FORMAT = new DateTimeFormatterBuilder().appendInstant().toFormatter(Locale.ENGLISH);
        private final OperationContext.ResultAction resultAction;
        private final String userId;
        private final String domainUuid;
        private final AccessMechanism accessMecanism;
        private final InetAddress inetAddress;
        private final List<ModelNode> operations;
        private final Instant date;

        public ConfigurationChange(OperationContext.ResultAction resultAction, String userId, String domainUuid, AccessMechanism accessMecanism, InetAddress inetAddress, List<ModelNode> operations) {
            this.resultAction = resultAction;
            this.userId = userId;
            this.domainUuid = domainUuid;
            this.accessMecanism = accessMecanism;
            this.inetAddress = inetAddress;
            this.operations = operations;
            this.date = Instant.now();
        }

        private String getDate() {
            return DATE_FORMAT.format(Instant.now());
        }

        public Instant getOperationInstant() {
            return this.date;
        }

        public ModelNode asModel() {
            ModelNode entry = new ModelNode().setEmptyObject();
            entry.get("operation-date").set(this.getDate());
            if (this.domainUuid != null) {
                entry.get("domain-uuid").set(this.domainUuid);
            }
            if (this.accessMecanism != null) {
                entry.get("access-mechanism").set(this.accessMecanism.toString());
            }
            if (this.inetAddress != null) {
                entry.get("remote-address").set(this.inetAddress.toString());
            }
            entry.get("outcome").set(this.resultAction == OperationContext.ResultAction.KEEP ? "success" : "failed");
            if (this.operations != null && !this.operations.isEmpty()) {
                ModelNode changes = entry.get("operations").setEmptyList();
                this.operations.stream().forEach(op -> changes.add((ModelNode)op));
            }
            return entry;
        }

        @Override
        public int compareTo(ConfigurationChange change) {
            return change.getOperationInstant().compareTo(this.date);
        }
    }

    public static class ConfigurationChangesCollectorImpl
    implements ConfigurationChangesCollector {
        private final TreeSet<ConfigurationChange> history = new TreeSet();
        private int maxHistory;

        private ConfigurationChangesCollectorImpl(int maxHistory) {
            this.maxHistory = maxHistory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConfigurationChanges(ConfigurationChange change) {
            TreeSet<ConfigurationChange> treeSet = this.history;
            synchronized (treeSet) {
                if (this.history.size() == this.maxHistory) {
                    this.history.remove(this.history.last());
                }
                this.history.add(change);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setMaxHistory(int maxHistory) {
            TreeSet<ConfigurationChange> treeSet = this.history;
            synchronized (treeSet) {
                this.maxHistory = maxHistory;
                while (maxHistory < this.history.size()) {
                    this.history.remove(this.history.last());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<ModelNode> getChanges() {
            TreeSet<ConfigurationChange> changes;
            TreeSet<ConfigurationChange> treeSet = this.history;
            synchronized (treeSet) {
                changes = new TreeSet<ConfigurationChange>((SortedSet<ConfigurationChange>)this.history);
            }
            ModelNode result = new ModelNode().setEmptyList();
            changes.stream().forEach(change -> result.add(change.asModel()));
            return result.asList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean trackAllowed() {
            TreeSet<ConfigurationChange> treeSet = this.history;
            synchronized (treeSet) {
                return this.maxHistory > 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deactivate() {
            TreeSet<ConfigurationChange> treeSet = this.history;
            synchronized (treeSet) {
                this.maxHistory = 0;
                this.history.clear();
            }
        }
    }
}

