/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.transport.tcp;

import infinispan.org.apache.commons.pool.impl.GenericKeyedObjectPool;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.client.hotrod.CacheTopologyInfo;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ServerConfiguration;
import org.infinispan.client.hotrod.configuration.SslConfiguration;
import org.infinispan.client.hotrod.event.ClientListenerNotifier;
import org.infinispan.client.hotrod.exceptions.TransportException;
import org.infinispan.client.hotrod.impl.TopologyInfo;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHash;
import org.infinispan.client.hotrod.impl.consistenthash.ConsistentHashFactory;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.FailoverRequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.PropsKeyedObjectPoolFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.RequestBalancingStrategy;
import org.infinispan.client.hotrod.impl.transport.tcp.SaslTransportObjectFactory;
import org.infinispan.client.hotrod.impl.transport.tcp.TcpTransport;
import org.infinispan.client.hotrod.impl.transport.tcp.TransportObjectFactory;
import org.infinispan.client.hotrod.logging.Log;
import org.infinispan.client.hotrod.logging.LogFactory;
import org.infinispan.commons.equivalence.AnyEquivalence;
import org.infinispan.commons.equivalence.ByteArrayEquivalence;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.SslContextFactory;
import org.infinispan.commons.util.Util;

@ThreadSafe
public class TcpTransportFactory
implements TransportFactory {
    private static final Log log = LogFactory.getLog(TcpTransportFactory.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final String DEFAULT_CLUSTER_NAME = "___DEFAULT-CLUSTER___";
    private final Object lock = new Object();
    private GenericKeyedObjectPool<SocketAddress, TcpTransport> connectionPool;
    private Map<byte[], FailoverRequestBalancingStrategy> balancers;
    private Configuration configuration;
    private Collection<SocketAddress> initialServers;
    private volatile boolean tcpNoDelay;
    private volatile boolean tcpKeepAlive;
    private volatile int soTimeout;
    private volatile int connectTimeout;
    private volatile int maxRetries;
    private volatile SSLContext sslContext;
    private volatile ClientListenerNotifier listenerNotifier;
    @GuardedBy(value="lock")
    private volatile TopologyInfo topologyInfo;
    private volatile String currentClusterName;
    private List<ClusterInfo> clusters = new ArrayList<ClusterInfo>();
    private final AtomicInteger topologyAge = new AtomicInteger(0);
    @GuardedBy(value="lock")
    private Map<byte[], Boolean> compatibilityCaches = CollectionFactory.makeMap(ByteArrayEquivalence.INSTANCE, AnyEquivalence.getInstance());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Codec codec, Configuration configuration, AtomicInteger defaultCacheTopologyId, ClientListenerNotifier listenerNotifier) {
        Object object = this.lock;
        synchronized (object) {
            this.listenerNotifier = listenerNotifier;
            this.configuration = configuration;
            boolean pingOnStartup = configuration.pingOnStartup();
            ArrayList<InetSocketAddress> servers = new ArrayList<InetSocketAddress>();
            this.initialServers = new ArrayList<SocketAddress>();
            for (ServerConfiguration server : configuration.servers()) {
                servers.add(new InetSocketAddress(server.host(), server.port()));
            }
            this.initialServers.addAll(servers);
            if (!configuration.clusters().isEmpty()) {
                configuration.clusters().stream().forEach(cluster -> {
                    Collection clusterAddresses = cluster.getCluster().stream().map(server -> new InetSocketAddress(server.host(), server.port())).collect(Collectors.toList());
                    ClusterInfo clusterInfo = new ClusterInfo(cluster.getClusterName(), clusterAddresses);
                    log.debugf("Add secondary cluster: %s", (Object)clusterInfo);
                    this.clusters.add(clusterInfo);
                });
                this.clusters.add(new ClusterInfo(DEFAULT_CLUSTER_NAME, this.initialServers));
            }
            this.currentClusterName = DEFAULT_CLUSTER_NAME;
            this.topologyInfo = new TopologyInfo(defaultCacheTopologyId, Collections.unmodifiableCollection(servers), configuration);
            this.tcpNoDelay = configuration.tcpNoDelay();
            this.tcpKeepAlive = configuration.tcpKeepAlive();
            this.soTimeout = configuration.socketTimeout();
            this.connectTimeout = configuration.connectionTimeout();
            this.maxRetries = configuration.maxRetries();
            if (configuration.security().ssl().enabled()) {
                SslConfiguration ssl = configuration.security().ssl();
                this.sslContext = ssl.sslContext() != null ? ssl.sslContext() : SslContextFactory.getContext(ssl.keyStoreFileName(), ssl.keyStorePassword(), ssl.trustStoreFileName(), ssl.trustStorePassword());
            }
            if (log.isDebugEnabled()) {
                log.debugf("Statically configured servers: %s", (Object)servers);
                log.debugf("Load balancer class: %s", (Object)configuration.balancingStrategyClass().getName());
                log.debugf("Tcp no delay = %b; client socket timeout = %d ms; connect timeout = %d ms", (Object)this.tcpNoDelay, (Object)this.soTimeout, (Object)this.connectTimeout);
            }
            TransportObjectFactory connectionFactory = configuration.security().authentication().enabled() ? new SaslTransportObjectFactory(codec, this, defaultCacheTopologyId, pingOnStartup, configuration.security().authentication()) : new TransportObjectFactory(codec, this, defaultCacheTopologyId, pingOnStartup);
            PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport> poolFactory = new PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport>(connectionFactory, configuration.connectionPool());
            this.createAndPreparePool(poolFactory);
            this.balancers = CollectionFactory.makeMap(ByteArrayEquivalence.INSTANCE, AnyEquivalence.getInstance());
            this.addBalancer(RemoteCacheManager.cacheNameBytes());
            if (configuration.pingOnStartup()) {
                this.pingServersIgnoreException();
            }
        }
    }

    private FailoverRequestBalancingStrategy addBalancer(byte[] cacheName) {
        RequestBalancingStrategy cfgBalancer;
        FailoverRequestBalancingStrategy cfgBalancerInstance = this.configuration.balancingStrategy();
        FailoverRequestBalancingStrategy balancer = cfgBalancerInstance != null ? cfgBalancerInstance : ((cfgBalancer = Util.getInstance(this.configuration.balancingStrategyClass())) instanceof FailoverRequestBalancingStrategy ? (FailoverRequestBalancingStrategy)cfgBalancer : new FailoverToRequestBalancingStrategyDelegate(cfgBalancer));
        this.balancers.put(cacheName, balancer);
        balancer.setServers(this.topologyInfo.getServers());
        return balancer;
    }

    private void pingServersIgnoreException() {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        Collection<SocketAddress> servers = this.topologyInfo.getServers();
        for (SocketAddress addr : servers) {
            try {
                pool.returnObject(addr, pool.borrowObject(addr));
            }
            catch (Exception e) {
                if (!trace) continue;
                log.tracef((Throwable)e, "Ignoring exception pinging configured servers %s to establish a connection", (Object)servers);
            }
        }
    }

    private void createAndPreparePool(PropsKeyedObjectPoolFactory<SocketAddress, TcpTransport> poolFactory) {
        this.connectionPool = (GenericKeyedObjectPool)poolFactory.createPool();
        Collection<SocketAddress> servers = this.topologyInfo.getServers();
        for (SocketAddress addr : servers) {
            this.connectionPool.preparePool(addr, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.connectionPool.clear();
            try {
                this.connectionPool.close();
            }
            catch (Exception e) {
                log.warn("Exception while shutting down the connection pool.", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheTopologyInfo getCacheTopologyInfo(byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            return this.topologyInfo.getCacheTopologyInfo(cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHashFunction(Map<SocketAddress, Set<Integer>> servers2Hash, int numKeyOwners, short hashFunctionVersion, int hashSpace, byte[] cacheName, AtomicInteger topologyId) {
        Object object = this.lock;
        synchronized (object) {
            this.topologyInfo.updateTopology(servers2Hash, numKeyOwners, hashFunctionVersion, hashSpace, cacheName, topologyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateHashFunction(SocketAddress[][] segmentOwners, int numSegments, short hashFunctionVersion, byte[] cacheName, AtomicInteger topologyId) {
        Object object = this.lock;
        synchronized (object) {
            this.topologyInfo.updateTopology(segmentOwners, numSegments, hashFunctionVersion, cacheName, topologyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport(Set<SocketAddress> failedServers, byte[] cacheName) {
        SocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            server = this.getNextServer(failedServers, cacheName);
        }
        return this.borrowTransportFromPool(server);
    }

    @GuardedBy(value="lock")
    private SocketAddress getNextServer(Set<SocketAddress> failedServers, byte[] cacheName) {
        FailoverRequestBalancingStrategy balancer = this.getOrCreateIfAbsentBalancer(cacheName);
        SocketAddress server = balancer.nextServer(failedServers);
        if (trace) {
            log.tracef("Using the balancer for determining the server: %s", (Object)server);
        }
        return server;
    }

    private FailoverRequestBalancingStrategy getOrCreateIfAbsentBalancer(byte[] cacheName) {
        FailoverRequestBalancingStrategy balancer = this.balancers.get(cacheName);
        if (balancer == null) {
            balancer = this.addBalancer(cacheName);
        }
        return balancer;
    }

    @Override
    public Transport getAddressTransport(SocketAddress server) {
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Transport getTransport(Object key, Set<SocketAddress> failedServers, byte[] cacheName) {
        SocketAddress server;
        Object object = this.lock;
        synchronized (object) {
            Optional<SocketAddress> hashAwareServer = this.topologyInfo.getHashAwareServer(key, cacheName);
            server = hashAwareServer.orElse(this.getNextServer(failedServers, cacheName));
        }
        return this.borrowTransportFromPool(server);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseTransport(Transport transport) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        TcpTransport tcpTransport = (TcpTransport)transport;
        if (!tcpTransport.isValid()) {
            try {
                if (trace) {
                    log.tracef("Dropping connection as it is no longer valid: %s", (Object)tcpTransport);
                }
                pool.invalidateObject(tcpTransport.getServerAddress(), tcpTransport);
            }
            catch (Exception e) {
                log.couldNoInvalidateConnection(tcpTransport, e);
            }
        } else {
            try {
                pool.returnObject(tcpTransport.getServerAddress(), tcpTransport);
            }
            catch (Exception e) {
                log.couldNotReleaseConnection(tcpTransport, e);
            }
            finally {
                this.logConnectionInfo(tcpTransport.getServerAddress());
            }
        }
    }

    @Override
    public void invalidateTransport(SocketAddress serverAddress, Transport transport) {
        transport.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateServers(Collection<SocketAddress> newServers, byte[] cacheName, boolean quiet) {
        Object object = this.lock;
        synchronized (object) {
            Collection<SocketAddress> servers = this.updateTopologyInfo(newServers, quiet);
            if (!servers.isEmpty()) {
                FailoverRequestBalancingStrategy balancer = this.getOrCreateIfAbsentBalancer(cacheName);
                balancer.setServers(servers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateServers(Collection<SocketAddress> newServers, boolean quiet) {
        Object object = this.lock;
        synchronized (object) {
            Collection<SocketAddress> servers = this.updateTopologyInfo(newServers, quiet);
            if (!servers.isEmpty()) {
                for (FailoverRequestBalancingStrategy balancer : this.balancers.values()) {
                    balancer.setServers(servers);
                }
            }
        }
    }

    @GuardedBy(value="lock")
    private Collection<SocketAddress> updateTopologyInfo(Collection<SocketAddress> newServers, boolean quiet) {
        Collection<SocketAddress> servers = this.topologyInfo.getServers();
        HashSet<SocketAddress> addedServers = new HashSet<SocketAddress>(newServers);
        addedServers.removeAll(servers);
        HashSet<SocketAddress> failedServers = new HashSet<SocketAddress>(servers);
        failedServers.removeAll(newServers);
        if (trace) {
            log.tracef("Current list: %s", (Object)servers);
            log.tracef("New list: %s", (Object)newServers);
            log.tracef("Added servers: %s", (Object)addedServers);
            log.tracef("Removed servers: %s", (Object)failedServers);
        }
        if (failedServers.isEmpty() && addedServers.isEmpty()) {
            log.debug("Same list of servers, not changing the pool");
            return Collections.emptyList();
        }
        for (SocketAddress server : addedServers) {
            log.newServerAdded(server);
            try {
                this.connectionPool.addObject(server);
            }
            catch (Exception e) {
                if (quiet) continue;
                log.failedAddingNewServer(server, e);
            }
        }
        for (SocketAddress server : failedServers) {
            log.removingServer(server);
            this.connectionPool.clear(server);
        }
        servers = Collections.unmodifiableList(new ArrayList<SocketAddress>(newServers));
        this.topologyInfo.updateServers(servers);
        if (!failedServers.isEmpty()) {
            this.listenerNotifier.failoverClientListeners(failedServers);
        }
        return servers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SocketAddress> getServers() {
        Object object = this.lock;
        synchronized (object) {
            return this.topologyInfo.getServers();
        }
    }

    private void logConnectionInfo(SocketAddress server) {
        if (trace) {
            GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
            log.tracef("For server %s: active = %d; idle = %d", (Object)server, (Object)pool.getNumActive(server), (Object)pool.getNumIdle(server));
        }
    }

    private Transport borrowTransportFromPool(SocketAddress server) {
        GenericKeyedObjectPool<SocketAddress, TcpTransport> pool = this.getConnectionPool();
        try {
            TcpTransport tcpTransport;
            TcpTransport tcpTransport2 = tcpTransport = (TcpTransport)pool.borrowObject(server);
            return tcpTransport2;
        }
        catch (Exception e) {
            String message = "Could not fetch transport";
            log.debug(message, e);
            throw new TransportException(message, e, server);
        }
        finally {
            this.logConnectionInfo(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsistentHash getConsistentHash(byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            return this.topologyInfo.getConsistentHash(cacheName);
        }
    }

    @Override
    public ConsistentHashFactory getConsistentHashFactory() {
        return this.topologyInfo.getConsistentHashFactory();
    }

    @Override
    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    @Override
    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    @Override
    public int getMaxRetries() {
        if (Thread.currentThread().isInterrupted()) {
            return -1;
        }
        return this.maxRetries;
    }

    @Override
    public int getSoTimeout() {
        return this.soTimeout;
    }

    @Override
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public void reset(byte[] cacheName) {
        this.updateServers(this.initialServers, cacheName, true);
        this.topologyInfo.setTopologyId(cacheName, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtomicInteger createTopologyId(byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            return this.topologyInfo.createTopologyId(cacheName, -1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getTopologyId(byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            return this.topologyInfo.getTopologyId(cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClusterSwitchStatus trySwitchCluster(String failedClusterName, byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            if (trace) {
                log.tracef("Trying to switch cluster away from '%s'", (Object)failedClusterName);
            }
            if (this.clusters.isEmpty()) {
                log.debugf("No alternative clusters configured, so can't switch cluster", new Object[0]);
                return ClusterSwitchStatus.NOT_SWITCHED;
            }
            String currentClusterName = this.currentClusterName;
            if (!this.isSwitchedClusterNotAvailable(failedClusterName, currentClusterName)) {
                log.debugf("Cluster already switched from failed cluster `%s` to `%s`, try again", (Object)failedClusterName, (Object)currentClusterName);
                return ClusterSwitchStatus.IN_PROGRESS;
            }
            if (this.topologyInfo.isTopologyValid(cacheName)) {
                if (trace) {
                    log.tracef("Switching clusters, failed cluster is '%s' and current cluster name is '%s'", (Object)failedClusterName, (Object)currentClusterName);
                }
                ArrayList<ClusterInfo> candidateClusters = new ArrayList<ClusterInfo>();
                for (ClusterInfo cluster : this.clusters) {
                    String clusterName = cluster.clusterName;
                    if (clusterName.equals(failedClusterName)) continue;
                    candidateClusters.add(cluster);
                }
                for (int i = 0; i < candidateClusters.size(); ++i) {
                    ClusterInfo cluster;
                    cluster = (ClusterInfo)candidateClusters.get(i % candidateClusters.size());
                    boolean alive = this.checkServersAlive(cluster.clusterAddresses);
                    if (!alive) continue;
                    this.topologyAge.incrementAndGet();
                    Collection<SocketAddress> servers = this.updateTopologyInfo(cluster.clusterAddresses, true);
                    if (!servers.isEmpty()) {
                        FailoverRequestBalancingStrategy balancer = this.getOrCreateIfAbsentBalancer(cacheName);
                        balancer.setServers(servers);
                    }
                    this.topologyInfo.setTopologyId(cacheName, -2);
                    this.currentClusterName = cluster.clusterName;
                    if (log.isInfoEnabled()) {
                        if (!cluster.clusterName.equals(DEFAULT_CLUSTER_NAME)) {
                            log.switchedToCluster(cluster.clusterName);
                        } else {
                            log.switchedBackToMainCluster();
                        }
                    }
                    return ClusterSwitchStatus.SWITCHED;
                }
                log.debugf("All cluster addresses viewed and none worked: %s", (Object)this.clusters);
                return ClusterSwitchStatus.NOT_SWITCHED;
            }
            return ClusterSwitchStatus.IN_PROGRESS;
        }
    }

    public boolean checkServersAlive(Collection<SocketAddress> servers) {
        for (SocketAddress server : servers) {
            try {
                this.connectionPool.addObject(server);
            }
            catch (Exception e) {
                log.tracef((Throwable)e, "Error checking whether this server is alive: %s", (Object)server);
                return false;
            }
        }
        return true;
    }

    private boolean isSwitchedClusterNotAvailable(String failedClusterName, String currentClusterName) {
        return currentClusterName.equals(failedClusterName);
    }

    @Override
    public Marshaller getMarshaller() {
        return this.listenerNotifier.getMarshaller();
    }

    @Override
    public boolean switchToCluster(String clusterName) {
        if (this.clusters.isEmpty()) {
            log.debugf("No alternative clusters configured, so can't switch cluster", new Object[0]);
            return false;
        }
        Collection<SocketAddress> addresses = this.findClusterInfo(clusterName);
        if (!addresses.isEmpty()) {
            this.updateServers(addresses, true);
            this.topologyInfo.setAllTopologyIds(-2);
            if (log.isInfoEnabled()) {
                if (!clusterName.equals(DEFAULT_CLUSTER_NAME)) {
                    log.manuallySwitchedToCluster(clusterName);
                } else {
                    log.manuallySwitchedBackToMainCluster();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentClusterName() {
        return this.currentClusterName;
    }

    @Override
    public int getTopologyAge() {
        return this.topologyAge.get();
    }

    private Collection<SocketAddress> findClusterInfo(String clusterName) {
        for (ClusterInfo cluster : this.clusters) {
            if (!cluster.clusterName.equals(clusterName)) continue;
            return cluster.clusterAddresses;
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestBalancingStrategy getBalancer(byte[] cacheName) {
        Object object = this.lock;
        synchronized (object) {
            return this.balancers.get(cacheName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericKeyedObjectPool<SocketAddress, TcpTransport> getConnectionPool() {
        Object object = this.lock;
        synchronized (object) {
            return this.connectionPool;
        }
    }

    private static final class ClusterInfo {
        final Collection<SocketAddress> clusterAddresses;
        final String clusterName;

        private ClusterInfo(String clusterName, Collection<SocketAddress> clusterAddresses) {
            this.clusterAddresses = clusterAddresses;
            this.clusterName = clusterName;
        }

        public String toString() {
            return "ClusterInfo{name='" + this.clusterName + '\'' + ", addresses=" + this.clusterAddresses + '}';
        }
    }

    private static class FailoverToRequestBalancingStrategyDelegate
    implements FailoverRequestBalancingStrategy {
        final RequestBalancingStrategy delegate;

        private FailoverToRequestBalancingStrategyDelegate(RequestBalancingStrategy delegate) {
            this.delegate = delegate;
        }

        @Override
        public void setServers(Collection<SocketAddress> servers) {
            this.delegate.setServers(servers);
        }

        @Override
        public SocketAddress nextServer() {
            return this.delegate.nextServer();
        }

        @Override
        public SocketAddress nextServer(Set<SocketAddress> failedServers) {
            return this.delegate.nextServer();
        }
    }

    public static enum ClusterSwitchStatus {
        NOT_SWITCHED,
        SWITCHED,
        IN_PROGRESS;

    }
}

