/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.interfaces;

import infinispan.org.jboss.as.controller.interfaces.InterfaceCriteria;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractInterfaceCriteria
implements InterfaceCriteria {
    private static final long serialVersionUID = -4266469792905191837L;

    protected abstract InetAddress isAcceptable(NetworkInterface var1, InetAddress var2) throws SocketException;

    @Override
    public Map<NetworkInterface, Set<InetAddress>> getAcceptableAddresses(Map<NetworkInterface, Set<InetAddress>> candidates) throws SocketException {
        HashMap<NetworkInterface, Set<InetAddress>> result = new HashMap<NetworkInterface, Set<InetAddress>>();
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : candidates.entrySet()) {
            NetworkInterface ni = entry.getKey();
            HashSet<InetAddress> addresses = null;
            for (InetAddress address : entry.getValue()) {
                InetAddress accepted = this.isAcceptable(ni, address);
                if (accepted == null) continue;
                if (addresses == null) {
                    addresses = new HashSet<InetAddress>();
                    result.put(ni, addresses);
                }
                addresses.add(accepted);
            }
        }
        return result;
    }

    public static Map<NetworkInterface, Set<InetAddress>> cloneCandidates(Map<NetworkInterface, Set<InetAddress>> candidates) {
        LinkedHashMap<NetworkInterface, Set<InetAddress>> clone = new LinkedHashMap<NetworkInterface, Set<InetAddress>>();
        for (Map.Entry<NetworkInterface, Set<InetAddress>> entry : candidates.entrySet()) {
            clone.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return clone;
    }
}

