/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.ssl;

import org.wildfly.security.ssl.CipherSuitePredicate;
import org.wildfly.security.ssl.MechanismDatabase;

final class AndCipherSuitePredicate
extends CipherSuitePredicate {
    private final CipherSuitePredicate[] predicates;

    AndCipherSuitePredicate(CipherSuitePredicate ... predicates) {
        this.predicates = predicates;
    }

    @Override
    boolean test(MechanismDatabase.Entry entry) {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || predicate.test(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isAlwaysTrue() {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || predicate.isAlwaysTrue()) continue;
            return false;
        }
        return true;
    }

    @Override
    boolean isAlwaysFalse() {
        for (CipherSuitePredicate predicate : this.predicates) {
            if (predicate == null || !predicate.isAlwaysFalse()) continue;
            return true;
        }
        return false;
    }
}

