/*
 * Decompiled with CFR 0.152.
 */
package infinispan.com.squareup.protoparser;

import infinispan.com.squareup.protoparser.MessageType;
import infinispan.com.squareup.protoparser.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ExtendDeclaration {
    private final String name;
    private final String fqname;
    private final String documentation;
    private final List<MessageType.Field> fields;

    public ExtendDeclaration(String name, String fqname, String documentation, List<MessageType.Field> fields) {
        MessageType.validateFieldTagUniqueness(fqname, fields);
        this.name = name;
        this.fqname = fqname;
        this.documentation = documentation;
        this.fields = Collections.unmodifiableList(new ArrayList<MessageType.Field>(fields));
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName() {
        return this.fqname;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public List<MessageType.Field> getFields() {
        return this.fields;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExtendDeclaration)) {
            return false;
        }
        ExtendDeclaration that = (ExtendDeclaration)other;
        return this.name.equals(that.name) && this.fqname.equals(that.fqname) && this.documentation.equals(that.documentation) && this.fields.equals(that.fields);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.fqname.hashCode();
        result = 31 * result + this.documentation.hashCode();
        result = 31 * result + this.fields.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Utils.appendDocumentation(builder, this.documentation);
        builder.append("extend ").append(this.name).append(" {");
        if (!this.fields.isEmpty()) {
            builder.append('\n');
            for (MessageType.Field field : this.fields) {
                Utils.appendIndented(builder, field.toString());
            }
        }
        return builder.append("}\n").toString();
    }
}

