/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.DeprecationData;
import infinispan.org.jboss.as.controller.ModelVersion;
import infinispan.org.jboss.as.controller.SimpleOperationDefinition;
import infinispan.org.jboss.as.controller.access.management.AccessConstraintDefinition;
import infinispan.org.jboss.as.controller.descriptions.DescriptionProvider;
import infinispan.org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import infinispan.org.jboss.as.controller.registry.OperationEntry;
import infinispan.org.jboss.dmr.ModelType;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;

public class SimpleOperationDefinitionBuilder {
    ResourceDescriptionResolver resolver;
    ResourceDescriptionResolver attributeResolver;
    protected String name;
    protected OperationEntry.EntryType entryType = OperationEntry.EntryType.PUBLIC;
    protected EnumSet<OperationEntry.Flag> flags = EnumSet.noneOf(OperationEntry.Flag.class);
    protected AttributeDefinition[] parameters = new AttributeDefinition[0];
    protected ModelType replyType;
    protected ModelType replyValueType;
    protected boolean replyAllowNull;
    protected DeprecationData deprecationData = null;
    protected AttributeDefinition[] replyParameters = new AttributeDefinition[0];
    protected AccessConstraintDefinition[] accessConstraints;
    DescriptionProvider descriptionProvider;
    boolean forceDefaultDescriptionProvider = false;

    public SimpleOperationDefinitionBuilder(String name, ResourceDescriptionResolver resolver) {
        this.name = name;
        this.resolver = resolver;
    }

    public SimpleOperationDefinition build() {
        if (this.attributeResolver == null) {
            this.attributeResolver = this.resolver;
        }
        return this.internalBuild(this.resolver, this.attributeResolver);
    }

    protected SimpleOperationDefinition internalBuild(ResourceDescriptionResolver resolver, ResourceDescriptionResolver attributeResolver) {
        return new SimpleOperationDefinition(this);
    }

    protected static EnumSet<OperationEntry.Flag> getFlagsSet(OperationEntry.Flag ... vararg) {
        EnumSet<OperationEntry.Flag> result = EnumSet.noneOf(OperationEntry.Flag.class);
        if (vararg != null && vararg.length > 0) {
            Collections.addAll(result, vararg);
        }
        return result;
    }

    public SimpleOperationDefinitionBuilder setEntryType(OperationEntry.EntryType entryType) {
        this.entryType = entryType;
        return this;
    }

    public SimpleOperationDefinitionBuilder setPrivateEntry() {
        this.entryType = OperationEntry.EntryType.PRIVATE;
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlags(EnumSet<OperationEntry.Flag> flags) {
        this.flags.addAll(flags);
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlags(OperationEntry.Flag ... flags) {
        this.flags.addAll(SimpleOperationDefinitionBuilder.getFlagsSet(flags));
        return this;
    }

    public SimpleOperationDefinitionBuilder withFlag(OperationEntry.Flag flag) {
        this.flags.add(flag);
        return this;
    }

    public SimpleOperationDefinitionBuilder setRuntimeOnly() {
        return this.withFlag(OperationEntry.Flag.RUNTIME_ONLY);
    }

    public SimpleOperationDefinitionBuilder setReadOnly() {
        return this.withFlag(OperationEntry.Flag.READ_ONLY);
    }

    public SimpleOperationDefinitionBuilder setParameters(AttributeDefinition ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public SimpleOperationDefinitionBuilder addParameter(AttributeDefinition parameter) {
        int i = this.parameters.length;
        this.parameters = Arrays.copyOf(this.parameters, i + 1);
        this.parameters[i] = parameter;
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyType(ModelType replyType) {
        this.replyType = replyType;
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyValueType(ModelType replyValueType) {
        this.replyValueType = replyValueType;
        return this;
    }

    public SimpleOperationDefinitionBuilder allowReturnNull() {
        this.replyAllowNull = true;
        return this;
    }

    public SimpleOperationDefinitionBuilder setDeprecated(ModelVersion since) {
        return this.setDeprecated(since, true);
    }

    public SimpleOperationDefinitionBuilder setDeprecated(ModelVersion since, boolean notificationUseful) {
        this.deprecationData = new DeprecationData(since, notificationUseful);
        return this;
    }

    public SimpleOperationDefinitionBuilder setReplyParameters(AttributeDefinition ... replyParameters) {
        this.replyParameters = replyParameters;
        return this;
    }

    public SimpleOperationDefinitionBuilder setAttributeResolver(ResourceDescriptionResolver resolver) {
        this.attributeResolver = resolver;
        return this;
    }

    public SimpleOperationDefinitionBuilder setAccessConstraints(AccessConstraintDefinition ... accessConstraints) {
        this.accessConstraints = accessConstraints;
        return this;
    }

    public SimpleOperationDefinitionBuilder addAccessConstraint(AccessConstraintDefinition accessConstraint) {
        if (this.accessConstraints == null) {
            this.accessConstraints = new AccessConstraintDefinition[]{accessConstraint};
        } else {
            this.accessConstraints = Arrays.copyOf(this.accessConstraints, this.accessConstraints.length + 1);
            this.accessConstraints[this.accessConstraints.length - 1] = accessConstraint;
        }
        return this;
    }

    SimpleOperationDefinitionBuilder setDescriptionProvider(DescriptionProvider provider) {
        this.descriptionProvider = provider;
        return this;
    }

    SimpleOperationDefinitionBuilder setForceDefaultDescriptionProvider() {
        this.forceDefaultDescriptionProvider = true;
        return this;
    }
}

