/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.access.HostEffect;
import infinispan.org.jboss.as.controller.access.ServerGroupEffect;
import infinispan.org.jboss.as.controller.access.TargetResource;
import infinispan.org.jboss.as.controller.access.management.AccessConstraintDefinition;
import infinispan.org.jboss.as.controller.registry.AttributeAccess;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class TargetAttribute {
    private static final List<AccessConstraintDefinition> NO_CONSTRAINTS = Collections.emptyList();
    private final String attributeName;
    private final TargetResource targetResource;
    private final AttributeAccess attributeAccess;
    private final ModelNode currentValue;

    public TargetAttribute(String attributeName, AttributeAccess attributeAccess, ModelNode currentValue, TargetResource targetResource) {
        this.attributeName = attributeName;
        this.targetResource = targetResource;
        this.currentValue = currentValue;
        this.attributeAccess = attributeAccess;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public TargetResource getTargetResource() {
        return this.targetResource;
    }

    public AttributeAccess.AccessType getAccessType() {
        return this.attributeAccess == null ? null : this.attributeAccess.getAccessType();
    }

    public AttributeAccess.Storage getStorageType() {
        return this.attributeAccess == null ? null : this.attributeAccess.getStorageType();
    }

    public AttributeDefinition getAttributeDefinition() {
        return this.attributeAccess == null ? null : this.attributeAccess.getAttributeDefinition();
    }

    public Set<AttributeAccess.Flag> getFlags() {
        if (this.attributeAccess == null) {
            return Collections.emptySet();
        }
        return this.attributeAccess.getFlags();
    }

    public ModelNode getCurrentValue() {
        return this.currentValue;
    }

    public ServerGroupEffect getServerGroupEffect() {
        return this.targetResource.getServerGroupEffect();
    }

    public HostEffect getHostEffect() {
        return this.targetResource.getHostEffect();
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        AttributeDefinition def = this.getAttributeDefinition();
        return def != null ? def.getAccessConstraints() : NO_CONSTRAINTS;
    }
}

