/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.audit;

import infinispan.org.jboss.as.controller.audit.AuditLogItem;
import java.text.SimpleDateFormat;

public abstract class AuditLogItemFormatter {
    public static final String TYPE_JMX = "jmx";
    public static final String TYPE_CORE = "core";
    protected final String name;
    private volatile String formattedString;
    private volatile boolean includeDate;
    private volatile String dateSeparator;
    private volatile SimpleDateFormat dateFormat;

    protected AuditLogItemFormatter(String name, boolean includeDate, String dateSeparator, String dateFormat) {
        this.name = name;
        this.includeDate = includeDate;
        this.dateSeparator = dateSeparator;
        this.dateFormat = new SimpleDateFormat(dateFormat);
    }

    public String getName() {
        return this.name;
    }

    public void setIncludeDate(boolean include) {
        this.includeDate = include;
    }

    public void setDateFormat(String pattern) {
        this.dateFormat = new SimpleDateFormat(pattern);
    }

    public void setDateSeparator(String dateSeparator) {
        this.dateSeparator = dateSeparator;
    }

    abstract String formatAuditLogItem(AuditLogItem.ModelControllerAuditLogItem var1);

    abstract String formatAuditLogItem(AuditLogItem.JmxAccessAuditLogItem var1);

    void clear() {
        this.formattedString = null;
    }

    protected void appendDate(StringBuilder sb, AuditLogItem auditLogItem) {
        if (this.includeDate) {
            sb.append(this.dateFormat.format(auditLogItem.getDate()));
            sb.append(this.dateSeparator);
        }
    }

    String getCachedString() {
        return this.formattedString;
    }

    String cacheString(String recordText) {
        this.formattedString = recordText;
        return this.formattedString;
    }
}

