/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.notification;

import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.notification.Notification;
import infinispan.org.jboss.as.controller.notification.NotificationHandler;
import infinispan.org.jboss.as.controller.notification.NotificationSupport;
import infinispan.org.jboss.as.controller.registry.NotificationHandlerRegistration;
import java.util.Arrays;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class NotificationSupports {
    NotificationSupports() {
    }

    private static void fireNotifications(NotificationHandlerRegistration registry, Notification ... notifications) {
        for (Notification notification : notifications) {
            try {
                for (NotificationHandler handler : registry.findMatchingNotificationHandlers(notification)) {
                    handler.handleNotification(notification);
                }
            }
            catch (Throwable t) {
                ControllerLogger.ROOT_LOGGER.failedToEmitNotification(notification, t);
            }
        }
    }

    static class NonBlockingNotificationSupport
    implements NotificationSupport {
        private final NotificationHandlerRegistration registry;
        private final ExecutorService executor;
        private final Queue<Notification> queue = new ConcurrentLinkedQueue<Notification>();
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        public NonBlockingNotificationSupport(NotificationHandlerRegistration registry, ExecutorService executor) {
            this.registry = registry;
            this.executor = executor;
        }

        @Override
        public synchronized void emit(Notification ... notifications) {
            this.queue.addAll(Arrays.asList(notifications));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    lock.writeLock().lock();
                    try {
                        Notification notification;
                        while ((notification = (Notification)queue.poll()) != null) {
                            NotificationSupports.fireNotifications(registry, new Notification[]{notification});
                        }
                    }
                    finally {
                        lock.writeLock().unlock();
                    }
                }
            });
        }

        @Override
        public NotificationHandlerRegistration getNotificationRegistry() {
            return this.registry;
        }
    }

    static class BlockingNotificationSupport
    implements NotificationSupport {
        private final NotificationHandlerRegistration registry;

        public BlockingNotificationSupport(NotificationHandlerRegistration registry) {
            this.registry = registry;
        }

        @Override
        public void emit(Notification ... notifications) {
            NotificationSupports.fireNotifications(this.registry, notifications);
        }

        @Override
        public NotificationHandlerRegistration getNotificationRegistry() {
            return this.registry;
        }
    }
}

