/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.global;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.dmr.ModelNode;
import java.io.IOException;
import java.io.InputStream;

public interface ReportAttacher {
    public void addReport(ModelNode var1) throws OperationFailedException;

    public void attachResult(OperationContext var1) throws OperationFailedException;

    public static abstract class AbstractReportAttacher
    implements ReportAttacher {
        protected final boolean record;
        protected static final byte[] EMPTY = new byte[0];

        public AbstractReportAttacher(boolean record) {
            this.record = record;
        }

        protected abstract InputStream getContent();

        protected abstract String getMimeType();

        @Override
        public void attachResult(OperationContext context) throws OperationFailedException {
            if (this.record) {
                try (InputStream content = this.getContent();){
                    context.attachResultStream(this.getMimeType(), content);
                }
                catch (IOException ex) {
                    throw ControllerLogger.MGMT_OP_LOGGER.failedToBuildReport(ex);
                }
            }
        }
    }
}

