/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.persistence;

import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.persistence.ConfigurationFile;
import infinispan.org.jboss.as.controller.persistence.ConfigurationFilePersistenceResource;
import infinispan.org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import infinispan.org.jboss.as.controller.persistence.ConfigurationPersister;
import infinispan.org.jboss.as.controller.persistence.ModelMarshallingContext;
import infinispan.org.jboss.as.controller.persistence.XmlConfigurationPersister;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.namespace.QName;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;

public class BackupXmlConfigurationPersister
extends XmlConfigurationPersister {
    ConfigurationFile configurationFile;
    private final AtomicBoolean successfulBoot = new AtomicBoolean();

    public BackupXmlConfigurationPersister(ConfigurationFile file, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser) {
        super(file.getBootFile(), rootElement, rootParser, rootDeparser, false);
        this.configurationFile = file;
    }

    public BackupXmlConfigurationPersister(ConfigurationFile file, QName rootElement, XMLElementReader<List<ModelNode>> rootParser, XMLElementWriter<ModelMarshallingContext> rootDeparser, boolean reload, boolean allowEmpty) {
        super(file.getBootFile(), rootElement, rootParser, rootDeparser, BackupXmlConfigurationPersister.isSuppressLoad(file, reload, allowEmpty));
        this.configurationFile = file;
    }

    private static boolean isSuppressLoad(ConfigurationFile configurationFile, boolean reload, boolean allowEmpty) {
        if (allowEmpty && configurationFile.getBootFile().length() == 0L) {
            return true;
        }
        ConfigurationFile.InteractionPolicy interactionPolicy = configurationFile.getInteractionPolicy();
        boolean initialEmpty = interactionPolicy == ConfigurationFile.InteractionPolicy.NEW || interactionPolicy == ConfigurationFile.InteractionPolicy.DISCARD;
        return initialEmpty && !reload;
    }

    @Override
    public void registerAdditionalRootElement(QName anotherRoot, XMLElementReader<List<ModelNode>> parser) {
        super.registerAdditionalRootElement(anotherRoot, parser);
    }

    @Override
    public void successfulBoot() throws ConfigurationPersistenceException {
        if (this.successfulBoot.compareAndSet(false, true)) {
            this.configurationFile.successfulBoot();
        }
    }

    @Override
    public ConfigurationPersister.PersistenceResource store(ModelNode model, Set<PathAddress> affectedAddresses) throws ConfigurationPersistenceException {
        if (!this.successfulBoot.get()) {
            return new ConfigurationPersister.PersistenceResource(){

                @Override
                public void commit() {
                }

                @Override
                public void rollback() {
                }
            };
        }
        return new ConfigurationFilePersistenceResource(model, this.configurationFile, this);
    }

    @Override
    public String snapshot() throws ConfigurationPersistenceException {
        return this.configurationFile.snapshot();
    }

    @Override
    public ConfigurationPersister.SnapshotInfo listSnapshots() {
        return this.configurationFile.listSnapshots();
    }

    @Override
    public void deleteSnapshot(String name) {
        this.configurationFile.deleteSnapshot(name);
    }
}

