/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol.mgmt;

import infinispan.org.jboss.as.protocol.logging.ProtocolLogger;
import infinispan.org.jboss.as.protocol.mgmt.ManagementByeByeHeader;
import infinispan.org.jboss.as.protocol.mgmt.ManagementPingHeader;
import infinispan.org.jboss.as.protocol.mgmt.ManagementPongHeader;
import infinispan.org.jboss.as.protocol.mgmt.ManagementProtocol;
import infinispan.org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import infinispan.org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import infinispan.org.jboss.as.protocol.mgmt.ProtocolUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public abstract class ManagementProtocolHeader {
    private int version;

    protected ManagementProtocolHeader(int version) {
        this.version = version;
    }

    public void write(DataOutput output) throws IOException {
        output.write(ManagementProtocol.SIGNATURE);
        output.writeByte(0);
        output.writeInt(this.getVersion());
        output.writeByte(1);
        output.writeByte(this.getType());
    }

    public int getVersion() {
        return this.version;
    }

    public abstract byte getType();

    protected static void validateSignature(DataInput input) throws IOException {
        byte[] signatureBytes = new byte[4];
        input.readFully(signatureBytes);
        if (!Arrays.equals(ManagementProtocol.SIGNATURE, signatureBytes)) {
            throw ProtocolLogger.ROOT_LOGGER.invalidSignature(Arrays.toString(signatureBytes));
        }
    }

    protected <T extends ManagementProtocolHeader> T cast(Class<T> expected) {
        return (T)((ManagementProtocolHeader)expected.cast(this));
    }

    public static ManagementProtocolHeader parse(DataInput input) throws IOException {
        ManagementProtocolHeader.validateSignature(input);
        ProtocolUtils.expectHeader(input, 0);
        int version = input.readInt();
        ProtocolUtils.expectHeader(input, 1);
        byte type = input.readByte();
        switch (type) {
            case 2: {
                return new ManagementRequestHeader(version, input);
            }
            case 3: {
                return new ManagementResponseHeader(version, input);
            }
            case 4: {
                return new ManagementByeByeHeader(version);
            }
            case 5: {
                return new ManagementPingHeader(version);
            }
            case 6: {
                return new ManagementPongHeader(version);
            }
        }
        throw ProtocolLogger.ROOT_LOGGER.invalidType("0x" + Integer.toHexString(type));
    }
}

