/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.msc.service;

import java.io.IOException;
import java.io.Writer;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.msc.service.Dependency;
import org.jboss.msc.service.Dependent;
import org.jboss.msc.service.IdentityHashSet;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceBuilderImpl;
import org.jboss.msc.service.ServiceContainerImpl;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceLogger;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistrationImpl;
import org.jboss.msc.service.ServiceRegistryException;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.ServiceTargetImpl;
import org.jboss.msc.service.SetTCCLAction;
import org.jboss.msc.service.StabilityMonitor;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.service.ValueInjection;
import org.jboss.msc.service.management.ServiceStatus;
import org.jboss.msc.value.Value;

final class ServiceControllerImpl<S>
implements ServiceController<S>,
Dependent {
    private static final String ILLEGAL_CONTROLLER_STATE = "Illegal controller state";
    private final Value<? extends Service<S>> serviceValue;
    private final Dependency[] dependencies;
    private final ValueInjection<?>[] injections;
    private final ValueInjection<?>[] outInjections;
    private final IdentityHashSet<ServiceListener<? super S>> listeners;
    private final IdentityHashSet<StabilityMonitor> monitors;
    private final ServiceRegistrationImpl primaryRegistration;
    private final ServiceRegistrationImpl[] aliasRegistrations;
    private final ServiceControllerImpl<?> parent;
    private final IdentityHashSet<ServiceControllerImpl<?>> children;
    private final IdentityHashSet<ServiceName> immediateUnavailableDependencies;
    private StartException startException;
    private ServiceController.Mode mode = ServiceController.Mode.NEVER;
    private ServiceController.Substate state = ServiceController.Substate.NEW;
    private int demandedByCount;
    private int unstartedDependencies;
    private int stoppingDependencies;
    private int runningDependents;
    private int failCount;
    private int transitiveUnavailableDepCount;
    private boolean dependenciesDemanded = false;
    private int asyncTasks;
    private volatile ChildServiceTarget childTarget;
    private volatile long lifecycleTime;
    private static final Dependent[] NO_DEPENDENTS = new Dependent[0];
    private static final ServiceControllerImpl<?>[] NO_CONTROLLERS = new ServiceControllerImpl[0];
    private static final String[] NO_STRINGS = new String[0];
    static final int MAX_DEPENDENCIES = 16383;
    private static final ServiceName[] NO_NAMES = new ServiceName[0];

    ServiceControllerImpl(Value<? extends Service<S>> serviceValue, Dependency[] dependencies, ValueInjection<?>[] injections, ValueInjection<?>[] outInjections, ServiceRegistrationImpl primaryRegistration, ServiceRegistrationImpl[] aliasRegistrations, Set<StabilityMonitor> monitors, Set<? extends ServiceListener<? super S>> listeners, ServiceControllerImpl<?> parent) {
        assert (dependencies.length <= 16383);
        this.serviceValue = serviceValue;
        this.dependencies = dependencies;
        this.injections = injections;
        this.outInjections = outInjections;
        this.primaryRegistration = primaryRegistration;
        this.aliasRegistrations = aliasRegistrations;
        this.listeners = new IdentityHashSet<ServiceListener<S>>(listeners);
        this.monitors = new IdentityHashSet<StabilityMonitor>(monitors);
        for (StabilityMonitor monitor : monitors) {
            monitor.addControllerNoCallback(this);
        }
        this.parent = parent;
        int depCount = dependencies.length;
        this.unstartedDependencies = 0;
        this.stoppingDependencies = parent == null ? depCount : depCount + 1;
        this.children = new IdentityHashSet();
        this.immediateUnavailableDependencies = new IdentityHashSet();
    }

    ServiceController.Substate getSubstateLocked() {
        return this.state;
    }

    void addAsyncTasks(int size) {
        this.asyncTasks += size;
    }

    void removeAsyncTask() {
        --this.asyncTasks;
    }

    void startInstallation() {
        for (Dependency dependency : this.dependencies) {
            dependency.addDependent(this);
        }
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.primaryRegistration.setInstance(this);
        for (Dependency dependency : this.aliasRegistrations) {
            ((ServiceRegistrationImpl)dependency).setInstance(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void commitInstallation(ServiceController.Mode initialMode) {
        boolean leavingRestState;
        assert (this.state == ServiceController.Substate.NEW);
        assert (initialMode != null);
        assert (!Thread.holdsLock(this));
        ArrayList<Runnable> listenerAddedTasks = new ArrayList<Runnable>(16);
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(16);
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            leavingRestState = this.isStableRestState();
            this.getListenerTasks(ListenerNotification.LISTENER_ADDED, listenerAddedTasks);
            this.internalSetMode(initialMode, tasks);
            this.asyncTasks += listenerAddedTasks.size() + tasks.size() + 1;
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
        tasks.clear();
        for (Runnable listenerAddedTask : listenerAddedTasks) {
            listenerAddedTask.run();
        }
        serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            leavingRestState = this.isStableRestState();
            for (Map.Entry<ServiceName, Dependent[]> dependentEntry : this.getDependentsByDependencyName().entrySet()) {
                ServiceName serviceName = dependentEntry.getKey();
                for (Dependent dependent : dependentEntry.getValue()) {
                    if (dependent == null) continue;
                    dependent.immediateDependencyAvailable(serviceName);
                }
            }
            Dependent[][] dependents = this.getDependents();
            if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0) {
                Dependent[][] arr$ = dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.transitiveDependencyUnavailable();
                    }
                }
            }
            if (this.failCount > 0) {
                tasks.add(new DependencyFailedTask(dependents, false));
            }
            this.state = ServiceController.Substate.DOWN;
            --this.asyncTasks;
            this.transition(tasks);
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackInstallation() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            this.mode = ServiceController.Mode.REMOVE;
            ++this.asyncTasks;
            this.state = ServiceController.Substate.CANCELLED;
            this.updateStabilityState(leavingRestState);
        }
        new RemoveTask().run();
    }

    boolean isInstallationCommitted() {
        assert (Thread.holdsLock(this));
        return this.state.compareTo(ServiceController.Substate.CANCELLED) > 0;
    }

    private boolean shouldStart() {
        assert (Thread.holdsLock(this));
        return this.unstartedDependencies == 0 && (this.mode == ServiceController.Mode.ACTIVE || this.mode == ServiceController.Mode.PASSIVE || this.demandedByCount > 0 && (this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.LAZY));
    }

    private boolean shouldStop() {
        assert (Thread.holdsLock(this));
        return this.unstartedDependencies > 0 || this.mode == ServiceController.Mode.NEVER || this.mode == ServiceController.Mode.REMOVE || this.demandedByCount == 0 && this.mode == ServiceController.Mode.ON_DEMAND;
    }

    boolean isStableRestState() {
        assert (Thread.holdsLock(this));
        return this.asyncTasks == 0 && this.state.isRestState();
    }

    void updateStabilityState(boolean leavingStableRestState) {
        block5: {
            boolean enteringStableRestState;
            block4: {
                assert (Thread.holdsLock(this));
                boolean bl = enteringStableRestState = this.state.isRestState() && this.asyncTasks == 0;
                if (!leavingStableRestState) break block4;
                if (enteringStableRestState) break block5;
                this.primaryRegistration.getContainer().incrementUnstableServices();
                for (StabilityMonitor monitor : this.monitors) {
                    monitor.incrementUnstableServices();
                }
                break block5;
            }
            if (enteringStableRestState) {
                this.primaryRegistration.getContainer().decrementUnstableServices();
                for (StabilityMonitor monitor : this.monitors) {
                    monitor.decrementUnstableServices();
                }
            }
        }
    }

    private ServiceController.Transition getTransition() {
        assert (Thread.holdsLock(this));
        switch (this.state) {
            case DOWN: {
                if (this.mode == ServiceController.Mode.REMOVE) {
                    return ServiceController.Transition.DOWN_to_REMOVING;
                }
                if (this.mode == ServiceController.Mode.NEVER) {
                    return ServiceController.Transition.DOWN_to_WONT_START;
                }
                if (this.shouldStart() && (this.mode != ServiceController.Mode.PASSIVE || this.stoppingDependencies == 0)) {
                    return ServiceController.Transition.DOWN_to_START_REQUESTED;
                }
                return ServiceController.Transition.DOWN_to_WAITING;
            }
            case WAITING: {
                if ((this.mode == ServiceController.Mode.ON_DEMAND || this.mode == ServiceController.Mode.LAZY) && this.demandedByCount <= 0 || this.mode == ServiceController.Mode.PASSIVE && this.stoppingDependencies != 0) break;
                return ServiceController.Transition.WAITING_to_DOWN;
            }
            case WONT_START: {
                if (this.mode == ServiceController.Mode.NEVER) break;
                return ServiceController.Transition.WONT_START_to_DOWN;
            }
            case STOPPING: {
                return ServiceController.Transition.STOPPING_to_DOWN;
            }
            case STOP_REQUESTED: {
                if (this.shouldStart() && this.stoppingDependencies == 0) {
                    return ServiceController.Transition.STOP_REQUESTED_to_UP;
                }
                if (this.runningDependents != 0) break;
                return ServiceController.Transition.STOP_REQUESTED_to_STOPPING;
            }
            case UP: {
                if (!this.shouldStop() && this.stoppingDependencies <= 0) break;
                return ServiceController.Transition.UP_to_STOP_REQUESTED;
            }
            case START_FAILED: {
                if (this.shouldStart()) {
                    if (this.stoppingDependencies == 0) {
                        if (this.startException != null) break;
                        return ServiceController.Transition.START_FAILED_to_STARTING;
                    }
                    return ServiceController.Transition.START_FAILED_to_DOWN;
                }
                return ServiceController.Transition.START_FAILED_to_DOWN;
            }
            case START_INITIATING: {
                return ServiceController.Transition.START_INITIATING_to_STARTING;
            }
            case STARTING: {
                if (this.startException == null) {
                    return ServiceController.Transition.STARTING_to_UP;
                }
                return ServiceController.Transition.STARTING_to_START_FAILED;
            }
            case START_REQUESTED: {
                if (this.shouldStart()) {
                    if (this.mode == ServiceController.Mode.PASSIVE && this.stoppingDependencies > 0) {
                        return ServiceController.Transition.START_REQUESTED_to_DOWN;
                    }
                    if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0 || this.failCount > 0) {
                        return ServiceController.Transition.START_REQUESTED_to_PROBLEM;
                    }
                    if (this.stoppingDependencies != 0) break;
                    return ServiceController.Transition.START_REQUESTED_to_START_INITIATING;
                }
                return ServiceController.Transition.START_REQUESTED_to_DOWN;
            }
            case PROBLEM: {
                if (this.shouldStart() && (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount != 0 || this.failCount != 0) && this.mode != ServiceController.Mode.PASSIVE) break;
                return ServiceController.Transition.PROBLEM_to_START_REQUESTED;
            }
            case REMOVING: {
                if (this.mode == ServiceController.Mode.REMOVE) {
                    return ServiceController.Transition.REMOVING_to_REMOVED;
                }
                return ServiceController.Transition.REMOVING_to_DOWN;
            }
            case CANCELLED: {
                return ServiceController.Transition.CANCELLED_to_REMOVED;
            }
        }
        return null;
    }

    void transition(ArrayList<Runnable> tasks) {
        assert (Thread.holdsLock(this));
        do {
            if (this.asyncTasks != 0) {
                return;
            }
            switch (this.mode) {
                case NEVER: 
                case REMOVE: {
                    if (!this.dependenciesDemanded) break;
                    tasks.add(new UndemandDependenciesTask());
                    this.dependenciesDemanded = false;
                    break;
                }
                case LAZY: {
                    if (this.state.getState() == ServiceController.State.UP && this.state != ServiceController.Substate.STOP_REQUESTED) {
                        if (this.dependenciesDemanded) break;
                        tasks.add(new DemandDependenciesTask());
                        this.dependenciesDemanded = true;
                        break;
                    }
                }
                case ON_DEMAND: 
                case PASSIVE: {
                    if (this.demandedByCount > 0 && !this.dependenciesDemanded) {
                        tasks.add(new DemandDependenciesTask());
                        this.dependenciesDemanded = true;
                        break;
                    }
                    if (this.demandedByCount != 0 || !this.dependenciesDemanded) break;
                    tasks.add(new UndemandDependenciesTask());
                    this.dependenciesDemanded = false;
                    break;
                }
                case ACTIVE: {
                    if (this.dependenciesDemanded) break;
                    tasks.add(new DemandDependenciesTask());
                    this.dependenciesDemanded = true;
                }
            }
            ServiceController.Transition transition = this.getTransition();
            if (transition == null) {
                return;
            }
            switch (transition) {
                case DOWN_to_WAITING: {
                    this.getListenerTasks(transition, tasks);
                    break;
                }
                case WAITING_to_DOWN: {
                    this.getListenerTasks(transition, tasks);
                    break;
                }
                case DOWN_to_WONT_START: {
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new ServiceUnavailableTask());
                    break;
                }
                case WONT_START_to_DOWN: {
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new ServiceAvailableTask());
                    break;
                }
                case STOPPING_to_DOWN: {
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case START_REQUESTED_to_DOWN: {
                    this.getListenerTasks(transition, tasks);
                    break;
                }
                case START_REQUESTED_to_START_INITIATING: {
                    tasks.add(new DependentStartedTask());
                    break;
                }
                case START_REQUESTED_to_PROBLEM: {
                    this.getPrimaryRegistration().getContainer().addProblem(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.addProblem(this);
                    }
                    if (!this.immediateUnavailableDependencies.isEmpty()) {
                        this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_UNAVAILABLE, tasks);
                    }
                    if (this.transitiveUnavailableDepCount > 0) {
                        this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_UNAVAILABLE, tasks);
                    }
                    if (this.failCount > 0) {
                        this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE, tasks);
                    }
                    this.getListenerTasks(transition, tasks);
                    break;
                }
                case UP_to_STOP_REQUESTED: {
                    if (this.mode == ServiceController.Mode.LAZY && this.demandedByCount == 0) {
                        assert (this.dependenciesDemanded);
                        tasks.add(new UndemandDependenciesTask());
                        this.dependenciesDemanded = false;
                    }
                    this.getListenerTasks(transition, tasks);
                    this.lifecycleTime = System.nanoTime();
                    tasks.add(new DependencyStoppedTask(this.getDependents()));
                    break;
                }
                case STARTING_to_UP: {
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new DependencyStartedTask(this.getDependents()));
                    break;
                }
                case STARTING_to_START_FAILED: {
                    this.getPrimaryRegistration().getContainer().addFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.addFailed(this);
                    }
                    ChildServiceTarget childTarget = this.childTarget;
                    if (childTarget != null) {
                        childTarget.valid = false;
                        this.childTarget = null;
                    }
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new DependencyFailedTask(this.getDependents(), true));
                    break;
                }
                case START_FAILED_to_STARTING: {
                    this.getPrimaryRegistration().getContainer().removeFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeFailed(this);
                    }
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new DependencyRetryingTask(this.getDependents()));
                    tasks.add(new DependentStartedTask());
                    break;
                }
                case START_INITIATING_to_STARTING: {
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new StartTask(true));
                    break;
                }
                case START_FAILED_to_DOWN: {
                    this.getPrimaryRegistration().getContainer().removeFailed(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeFailed(this);
                    }
                    this.startException = null;
                    --this.failCount;
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new DependencyRetryingTask(this.getDependents()));
                    tasks.add(new StopTask(true));
                    tasks.add(new DependentStoppedTask());
                    break;
                }
                case STOP_REQUESTED_to_UP: {
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new DependencyStartedTask(this.getDependents()));
                    break;
                }
                case STOP_REQUESTED_to_STOPPING: {
                    ChildServiceTarget childTarget = this.childTarget;
                    if (childTarget != null) {
                        childTarget.valid = false;
                        this.childTarget = null;
                    }
                    this.getListenerTasks(transition, tasks);
                    tasks.add(new StopTask(false));
                    break;
                }
                case DOWN_to_REMOVING: {
                    tasks.add(new ServiceUnavailableTask());
                    Dependent[][] dependents = this.getDependents();
                    if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0) {
                        Dependent[][] arr$ = dependents;
                        int len$ = arr$.length;
                        for (int i$ = 0; i$ < len$; ++i$) {
                            Dependent[] dependentArray;
                            for (Dependent dependent : dependentArray = arr$[i$]) {
                                if (dependent == null) continue;
                                dependent.transitiveDependencyAvailable();
                            }
                        }
                    }
                    if (this.failCount > 0) {
                        tasks.add(new DependencyRetryingTask(dependents));
                    }
                    tasks.add(new RemoveTask());
                    break;
                }
                case CANCELLED_to_REMOVED: 
                case REMOVING_to_REMOVED: {
                    this.getListenerTasks(transition, tasks);
                    this.listeners.clear();
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeControllerNoCallback(this);
                    }
                    break;
                }
                case REMOVING_to_DOWN: {
                    break;
                }
                case DOWN_to_START_REQUESTED: {
                    this.getListenerTasks(transition, tasks);
                    break;
                }
                case PROBLEM_to_START_REQUESTED: {
                    this.getPrimaryRegistration().getContainer().removeProblem(this);
                    for (StabilityMonitor monitor : this.monitors) {
                        monitor.removeProblem(this);
                    }
                    if (!this.immediateUnavailableDependencies.isEmpty()) {
                        this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_AVAILABLE, tasks);
                    }
                    if (this.transitiveUnavailableDepCount > 0) {
                        this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_AVAILABLE, tasks);
                    }
                    if (this.failCount > 0) {
                        this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE_CLEAR, tasks);
                    }
                    this.getListenerTasks(transition, tasks);
                    this.lifecycleTime = System.nanoTime();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = transition.getAfter();
        } while (tasks.isEmpty());
        this.notifyAll();
    }

    private void getListenerTasks(ServiceController.Transition transition, ArrayList<Runnable> tasks) {
        for (ServiceListener<? super S> serviceListener : this.listeners) {
            tasks.add(new ListenerTask(serviceListener, transition));
        }
    }

    private void getListenerTasks(ListenerNotification notification, ArrayList<Runnable> tasks) {
        for (ServiceListener<? super S> serviceListener : this.listeners) {
            tasks.add(new ListenerTask(serviceListener, notification));
        }
    }

    void doExecute(ArrayList<Runnable> tasks) {
        assert (!Thread.holdsLock(this));
        if (tasks == null) {
            return;
        }
        Executor executor = this.primaryRegistration.getContainer().getExecutor();
        for (Runnable task : tasks) {
            try {
                executor.execute(task);
            }
            catch (RejectedExecutionException e) {
                task.run();
            }
        }
    }

    @Override
    public void setMode(ServiceController.Mode newMode) {
        this.internalSetMode(null, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        assert (!Thread.holdsLock(this));
        if (newMode == null) {
            throw new IllegalArgumentException("newMode is null");
        }
        if (newMode != ServiceController.Mode.REMOVE && this.primaryRegistration.getContainer().isShutdown()) {
            throw new IllegalArgumentException("Container is shutting down");
        }
        ArrayList<Runnable> tasks = new ArrayList<Runnable>(4);
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            ServiceController.Mode oldMode = this.mode;
            if (expectedMode != null && expectedMode != oldMode) {
                return false;
            }
            if (oldMode == newMode) {
                return true;
            }
            this.internalSetMode(newMode, tasks);
            if (tasks.isEmpty()) {
                this.transition(tasks);
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
        return true;
    }

    private void internalSetMode(ServiceController.Mode newMode, ArrayList<Runnable> taskList) {
        assert (Thread.holdsLock(this));
        ServiceController.Mode oldMode = this.mode;
        if (oldMode == ServiceController.Mode.REMOVE) {
            if (this.state.compareTo(ServiceController.Substate.REMOVING) >= 0) {
                throw new IllegalStateException("Service already removed");
            }
            this.getListenerTasks(ListenerNotification.REMOVE_REQUEST_CLEARED, taskList);
        }
        if (newMode == ServiceController.Mode.REMOVE) {
            this.getListenerTasks(ListenerNotification.REMOVE_REQUESTED, taskList);
        }
        this.mode = newMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyAvailable(ServiceName dependencyName) {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            assert (this.immediateUnavailableDependencies.contains(dependencyName));
            this.immediateUnavailableDependencies.remove(dependencyName);
            if (!this.immediateUnavailableDependencies.isEmpty() || this.state.compareTo(ServiceController.Substate.CANCELLED) <= 0 || this.state.compareTo(ServiceController.Substate.REMOVING) >= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == ServiceController.Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_AVAILABLE, tasks);
            }
            if (this.transitiveUnavailableDepCount == 0) {
                this.transition(tasks);
                this.propagateTransitiveAvailability();
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUnavailable(ServiceName dependencyName) {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            this.immediateUnavailableDependencies.add(dependencyName);
            if (this.immediateUnavailableDependencies.size() != 1 || this.state.compareTo(ServiceController.Substate.CANCELLED) <= 0 || this.state.compareTo(ServiceController.Substate.REMOVING) >= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == ServiceController.Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.IMMEDIATE_DEPENDENCY_UNAVAILABLE, tasks);
            }
            if (this.transitiveUnavailableDepCount == 0) {
                this.transition(tasks);
                this.propagateTransitiveUnavailability();
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    private void propagateTransitiveUnavailability() {
        assert (Thread.holdsLock(this));
        Dependent[][] arr$ = this.getDependents();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Dependent[] dependentArray;
            for (Dependent dependent : dependentArray = arr$[i$]) {
                if (dependent == null) continue;
                dependent.transitiveDependencyUnavailable();
            }
        }
    }

    private void propagateTransitiveAvailability() {
        Dependent[][] arr$ = this.getDependents();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Dependent[] dependentArray;
            for (Dependent dependent : dependentArray = arr$[i$]) {
                if (dependent == null) continue;
                dependent.transitiveDependencyAvailable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyAvailable() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (--this.transitiveUnavailableDepCount != 0 || this.state.compareTo(ServiceController.Substate.CANCELLED) <= 0 || this.state.compareTo(ServiceController.Substate.REMOVING) >= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == ServiceController.Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_AVAILABLE, tasks);
            }
            if (this.immediateUnavailableDependencies.isEmpty()) {
                this.transition(tasks);
                this.propagateTransitiveAvailability();
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transitiveDependencyUnavailable() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (++this.transitiveUnavailableDepCount != 1 || this.state.compareTo(ServiceController.Substate.CANCELLED) <= 0 || this.state.compareTo(ServiceController.Substate.REMOVING) >= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>(16);
            if (this.state == ServiceController.Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.TRANSITIVE_DEPENDENCY_UNAVAILABLE, tasks);
            }
            if (this.immediateUnavailableDependencies.isEmpty()) {
                this.transition(tasks);
                this.propagateTransitiveUnavailability();
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    @Override
    public ServiceControllerImpl<?> getController() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyUp() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (--this.stoppingDependencies != 0) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void immediateDependencyDown() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (++this.stoppingDependencies != 1) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailed() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (++this.failCount != 1 || this.state.compareTo(ServiceController.Substate.CANCELLED) <= 0) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            if (this.state == ServiceController.Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE, tasks);
            }
            tasks.add(new DependencyFailedTask(this.getDependents(), false));
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dependencyFailureCleared() {
        ArrayList<Runnable> tasks;
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (--this.failCount != 0 || this.state == ServiceController.Substate.CANCELLED) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            if (this.state == ServiceController.Substate.PROBLEM) {
                this.getListenerTasks(ListenerNotification.DEPENDENCY_FAILURE_CLEAR, tasks);
            }
            tasks.add(new DependencyRetryingTask(this.getDependents()));
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStarted() {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            ++this.runningDependents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dependentStopped() {
        ArrayList<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (--this.runningDependents != 0) {
                return;
            }
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    void newDependent(ServiceName dependencyName, Dependent dependent) {
        assert (Thread.holdsLock(this));
        if (this.failCount > 0 && this.state != ServiceController.Substate.STARTING) {
            dependent.dependencyFailed();
        }
        if (!this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount > 0) {
            dependent.transitiveDependencyUnavailable();
        }
        if (this.state == ServiceController.Substate.WONT_START) {
            dependent.immediateDependencyUnavailable(dependencyName);
        } else if (this.state.getState() == ServiceController.State.UP && this.state != ServiceController.Substate.STOP_REQUESTED) {
            dependent.immediateDependencyUp();
        }
    }

    private void doDemandDependencies() {
        assert (!Thread.holdsLock(this));
        for (Dependency dependency : this.dependencies) {
            dependency.addDemand();
        }
        ServiceControllerImpl<?> parent = this.parent;
        if (parent != null) {
            parent.addDemand();
        }
    }

    private void doUndemandDependencies() {
        assert (!Thread.holdsLock(this));
        for (Dependency dependency : this.dependencies) {
            dependency.removeDemand();
        }
        ServiceControllerImpl<?> parent = this.parent;
        if (parent != null) {
            parent.removeDemand();
        }
    }

    void addDemand() {
        this.addDemands(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDemands(int demandedByCount) {
        assert (!Thread.holdsLock(this));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            boolean leavingRestState = this.isStableRestState();
            int cnt = this.demandedByCount;
            this.demandedByCount += demandedByCount;
            boolean notStartedLazy = this.mode == ServiceController.Mode.LAZY && (this.state.getState() != ServiceController.State.UP || this.state == ServiceController.Substate.STOP_REQUESTED);
            boolean bl = propagate = cnt == 0 && (this.mode == ServiceController.Mode.ON_DEMAND || notStartedLazy || this.mode == ServiceController.Mode.PASSIVE);
            if (propagate) {
                this.transition(tasks);
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeDemand() {
        assert (!Thread.holdsLock(this));
        ArrayList<Runnable> tasks = new ArrayList<Runnable>();
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean propagate;
            boolean leavingRestState = this.isStableRestState();
            int cnt = --this.demandedByCount;
            boolean notStartedLazy = this.mode == ServiceController.Mode.LAZY && (this.state.getState() != ServiceController.State.UP || this.state == ServiceController.Substate.STOP_REQUESTED);
            boolean bl = propagate = cnt == 0 && (this.mode == ServiceController.Mode.ON_DEMAND || notStartedLazy || this.mode == ServiceController.Mode.PASSIVE);
            if (propagate) {
                this.transition(tasks);
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addChild(ServiceControllerImpl<?> child) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            switch (this.state) {
                case STOP_REQUESTED: 
                case UP: 
                case START_INITIATING: 
                case STARTING: {
                    this.children.add(child);
                    this.newDependent(this.primaryRegistration.getName(), child);
                    break;
                }
                default: {
                    throw new IllegalStateException("Children cannot be added in state " + (Object)((Object)this.state.getState()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChild(ServiceControllerImpl<?> child) {
        ArrayList<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState;
            block8: {
                block7: {
                    leavingRestState = this.isStableRestState();
                    this.children.remove(child);
                    if (!this.children.isEmpty()) break block7;
                    switch (this.state) {
                        case STOPPING: 
                        case START_FAILED: {
                            --this.asyncTasks;
                            tasks = new ArrayList<Runnable>();
                            this.transition(tasks);
                            break block8;
                        }
                        default: {
                            return;
                        }
                    }
                }
                return;
            }
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    IdentityHashSet<ServiceControllerImpl<?>> getChildren() {
        assert (Thread.holdsLock(this));
        return this.children;
    }

    @Override
    public ServiceControllerImpl<?> getParent() {
        return this.parent;
    }

    @Override
    public ServiceContainerImpl getServiceContainer() {
        return this.primaryRegistration.getContainer();
    }

    @Override
    public ServiceController.State getState() {
        return this.state.getState();
    }

    @Override
    public S getValue() throws IllegalStateException {
        return (S)this.serviceValue.getValue().getValue();
    }

    @Override
    public S awaitValue() throws IllegalStateException, InterruptedException {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            while (true) {
                switch (this.state.getState()) {
                    case UP: {
                        return (S)this.serviceValue.getValue().getValue();
                    }
                    case START_FAILED: {
                        throw new IllegalStateException("Failed to start service", this.startException);
                    }
                    case REMOVED: {
                        throw new IllegalStateException("Service was removed");
                    }
                }
                this.wait();
            }
        }
    }

    @Override
    public S awaitValue(long time, TimeUnit unit) throws IllegalStateException, InterruptedException, TimeoutException {
        assert (!Thread.holdsLock(this));
        long then = System.nanoTime();
        long remaining = unit.toNanos(time);
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            long now;
            do {
                switch (this.state.getState()) {
                    case UP: {
                        return (S)this.serviceValue.getValue().getValue();
                    }
                    case START_FAILED: {
                        throw new IllegalStateException("Failed to start service", this.startException);
                    }
                    case REMOVED: {
                        throw new IllegalStateException("Service was removed");
                    }
                }
                this.wait(remaining / 1000000L, (int)(remaining % 1000000L));
            } while ((remaining -= (now = System.nanoTime()) - (then = now)) > 0L);
            throw new TimeoutException("Operation timed out");
        }
    }

    @Override
    public Service<S> getService() throws IllegalStateException {
        return this.serviceValue.getValue();
    }

    @Override
    public ServiceName getName() {
        return this.primaryRegistration.getName();
    }

    @Override
    public ServiceName[] getAliases() {
        ServiceRegistrationImpl[] aliasRegistrations = this.aliasRegistrations;
        int len = aliasRegistrations.length;
        if (len == 0) {
            return NO_NAMES;
        }
        ServiceName[] names = new ServiceName[len];
        for (int i = 0; i < len; ++i) {
            names[i] = aliasRegistrations[i].getName();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ServiceListener<? super S> listener) {
        ServiceController.Substate state;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            state = this.state;
            if (state != ServiceController.Substate.REMOVED) {
                if (this.listeners.contains(listener)) {
                    throw new IllegalArgumentException("Listener " + listener + " already present on controller for " + this.primaryRegistration.getName());
                }
                this.listeners.add(listener);
                ++this.asyncTasks;
            } else {
                this.asyncTasks += 2;
            }
            this.updateStabilityState(leavingRestState);
        }
        this.invokeListener(listener, ListenerNotification.LISTENER_ADDED, null);
        if (state == ServiceController.Substate.REMOVED) {
            this.invokeListener(listener, ListenerNotification.TRANSITION, ServiceController.Transition.REMOVING_to_REMOVED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ServiceListener<? super S> listener) {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartException getStartException() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.startException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retry() {
        ArrayList<Runnable> tasks;
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            boolean leavingRestState = this.isStableRestState();
            if (this.state.getState() != ServiceController.State.START_FAILED) {
                return;
            }
            --this.failCount;
            assert (this.failCount == 0);
            this.startException = null;
            tasks = new ArrayList<Runnable>();
            this.transition(tasks);
            this.asyncTasks += tasks.size();
            this.updateStabilityState(leavingRestState);
        }
        this.doExecute(tasks);
    }

    @Override
    public synchronized Set<ServiceName> getImmediateUnavailableDependencies() {
        return this.immediateUnavailableDependencies.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Mode getMode() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.mode;
        }
    }

    @Override
    public boolean compareAndSetMode(ServiceController.Mode expectedMode, ServiceController.Mode newMode) {
        if (expectedMode == null) {
            throw new IllegalArgumentException("expectedMode is null");
        }
        return this.internalSetMode(expectedMode, newMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceStatus getStatus() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            String[] dependencyNames;
            String[] aliases;
            String parentName = this.parent == null ? null : this.parent.getName().getCanonicalName();
            String name = this.primaryRegistration.getName().getCanonicalName();
            ServiceRegistrationImpl[] aliasRegistrations = this.aliasRegistrations;
            int aliasLength = aliasRegistrations.length;
            if (aliasLength == 0) {
                aliases = NO_STRINGS;
            } else {
                aliases = new String[aliasLength];
                for (int i = 0; i < aliasLength; ++i) {
                    aliases[i] = aliasRegistrations[i].getName().getCanonicalName();
                }
            }
            String serviceClass = "<unknown>";
            try {
                Service<S> value = this.serviceValue.getValue();
                if (value != null) {
                    serviceClass = value.getClass().getName();
                }
            }
            catch (RuntimeException ignored) {
                // empty catch block
            }
            Dependency[] dependencies = this.dependencies;
            int dependenciesLength = dependencies.length;
            if (dependenciesLength == 0) {
                dependencyNames = NO_STRINGS;
            } else {
                dependencyNames = new String[dependenciesLength];
                for (int i = 0; i < dependenciesLength; ++i) {
                    dependencyNames[i] = dependencies[i].getName().getCanonicalName();
                }
            }
            StartException startException = this.startException;
            return new ServiceStatus(parentName, name, aliases, serviceClass, this.mode.name(), this.state.getState().name(), this.state.name(), dependencyNames, this.failCount != 0, startException != null ? startException.toString() : null, !this.immediateUnavailableDependencies.isEmpty() || this.transitiveUnavailableDepCount != 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    String dumpServiceDetails() {
        void var2_7;
        Object dependents;
        StringBuilder b = new StringBuilder();
        ServiceRegistrationImpl serviceRegistrationImpl = this.primaryRegistration;
        synchronized (serviceRegistrationImpl) {
            dependents = this.primaryRegistration.getDependents();
            IdentityHashSet<Dependent> identityHashSet = dependents;
            synchronized (identityHashSet) {
                dependents = ((IdentityHashSet)dependents).clone();
            }
        }
        b.append("Service Name: ").append(this.primaryRegistration.getName().toString()).append(" - Dependents: ").append(((IdentityHashSet)dependents).size()).append('\n');
        Iterator iterator = ((IdentityHashSet)dependents).iterator();
        while (iterator.hasNext()) {
            ServiceControllerImpl<?> controller;
            Dependent dependent = (Dependent)iterator.next();
            ServiceControllerImpl<?> serviceControllerImpl = controller = dependent.getController();
            synchronized (serviceControllerImpl) {
                b.append("        ").append(controller.getName().toString()).append(" - State: ").append((Object)controller.state.getState()).append(" (Substate: ").append((Object)controller.state).append(")\n");
            }
        }
        b.append("Service Aliases: ").append(this.aliasRegistrations.length).append('\n');
        ServiceRegistrationImpl[] serviceRegistrationImplArray = this.aliasRegistrations;
        int len$ = serviceRegistrationImplArray.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            ServiceRegistrationImpl serviceRegistrationImpl2;
            ServiceRegistrationImpl serviceRegistrationImpl3 = serviceRegistrationImpl2 = serviceRegistrationImplArray[i$];
            synchronized (serviceRegistrationImpl3) {
                dependents = serviceRegistrationImpl2.getDependents();
                IdentityHashSet<Dependent> identityHashSet = dependents;
                synchronized (identityHashSet) {
                    dependents = ((IdentityHashSet)dependents).clone();
                }
            }
            b.append("    ").append(serviceRegistrationImpl2.getName().toString()).append(" - Dependents: ").append(((IdentityHashSet)dependents).size()).append('\n');
            Iterator i$2 = ((IdentityHashSet)dependents).iterator();
            while (i$2.hasNext()) {
                Dependent dependent = (Dependent)i$2.next();
                ServiceControllerImpl<?> controller = dependent.getController();
                b.append("        ").append(controller.getName().toString()).append(" - State: ").append((Object)controller.state.getState()).append(" (Substate: ").append((Object)controller.state).append(")\n");
            }
        }
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            void var6_27;
            b.append("Children: ").append(this.children.size()).append('\n');
            Iterator<ServiceControllerImpl<?>> i$ = this.children.iterator();
            while (i$.hasNext()) {
                ServiceControllerImpl<?> child;
                ServiceControllerImpl<?> serviceControllerImpl2 = child = i$.next();
                synchronized (serviceControllerImpl2) {
                    b.append("    ").append(child.getName().toString()).append(" - State: ").append((Object)child.state.getState()).append(" (Substate: ").append((Object)child.state).append(")\n");
                }
            }
            ServiceController.Substate state = this.state;
            b.append("State: ").append((Object)state.getState()).append(" (Substate: ").append((Object)state).append(")\n");
            if (this.parent != null) {
                b.append("Parent Name: ").append(this.parent.getPrimaryRegistration().getName().toString()).append('\n');
            }
            b.append("Service Mode: ").append((Object)this.mode).append('\n');
            if (this.startException != null) {
                b.append("Start Exception: ").append(this.startException.getClass().getName()).append(" (Message: ").append(this.startException.getMessage()).append(")\n");
            }
            String serviceValueString = "(indeterminate)";
            try {
                serviceValueString = this.serviceValue.toString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            b.append("Service Value: ").append(serviceValueString).append('\n');
            String string = "(indeterminate)";
            Object serviceObjectClass = "(indeterminate)";
            try {
                Service<S> serviceObject = this.serviceValue.getValue();
                if (serviceObject != null) {
                    serviceObjectClass = serviceObject.getClass();
                    String string2 = serviceObject.toString();
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            b.append("Service Object: ").append((String)var6_27).append('\n');
            b.append("Service Object Class: ").append(serviceObjectClass).append('\n');
            b.append("Demanded By: ").append(this.demandedByCount).append('\n');
            b.append("Unstarted Dependencies: ").append(this.unstartedDependencies).append('\n');
            b.append("Stopping Dependencies: ").append(this.stoppingDependencies).append('\n');
            b.append("Running Dependents: ").append(this.runningDependents).append('\n');
            b.append("Fail Count: ").append(this.failCount).append('\n');
            b.append("Immediate Unavailable Dep Count: ").append(this.immediateUnavailableDependencies.size()).append('\n');
            for (ServiceName name : this.immediateUnavailableDependencies) {
                b.append("    ").append(name.toString()).append('\n');
            }
            b.append("Transitive Unavailable Dep Count: ").append(this.transitiveUnavailableDepCount).append('\n');
            b.append("Dependencies Demanded: ").append(this.dependenciesDemanded ? "yes" : "no").append('\n');
            b.append("Async Tasks: ").append(this.asyncTasks).append('\n');
            if (this.lifecycleTime != 0L) {
                long elapsedNanos = System.nanoTime() - this.lifecycleTime;
                long now = System.currentTimeMillis();
                long stamp = now - elapsedNanos / 1000000L;
                b.append("Lifecycle Timestamp: ").append(this.lifecycleTime).append(String.format(" = %tb %<td %<tH:%<tM:%<tS.%<tL%n", stamp));
            }
        }
        b.append("Dependencies: ").append(this.dependencies.length).append('\n');
        boolean bl = false;
        while (var2_7 < this.dependencies.length) {
            Dependency dependency = this.dependencies[var2_7];
            ServiceControllerImpl<?> controller = dependency.getDependencyController();
            b.append("    ").append(dependency.getName().toString());
            if (controller == null) {
                b.append(" (missing)\n");
            } else {
                ServiceControllerImpl<?> serviceControllerImpl3 = controller;
                synchronized (serviceControllerImpl3) {
                    b.append(" - State: ").append((Object)controller.state.getState()).append(" (Substate: ").append((Object)controller.state).append(")\n");
                }
            }
            ++var2_7;
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMonitor(StabilityMonitor stabilityMonitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.monitors.add(stabilityMonitor) && !this.isStableRestState()) {
                stabilityMonitor.incrementUnstableServices();
                if (this.state == ServiceController.Substate.START_FAILED) {
                    stabilityMonitor.addFailed(this);
                } else if (this.state == ServiceController.Substate.PROBLEM) {
                    stabilityMonitor.addProblem(this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitor(StabilityMonitor stabilityMonitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            if (this.monitors.remove(stabilityMonitor) && !this.isStableRestState()) {
                stabilityMonitor.removeProblem(this);
                stabilityMonitor.removeFailed(this);
                stabilityMonitor.decrementUnstableServices();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeMonitorNoCallback(StabilityMonitor stabilityMonitor) {
        assert (!Thread.holdsLock(this));
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            this.monitors.remove(stabilityMonitor);
        }
    }

    Set<StabilityMonitor> getMonitors() {
        assert (Thread.holdsLock(this));
        return this.monitors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void invokeListener(ServiceListener<? super S> listener, ListenerNotification notification, ServiceController.Transition transition) {
        assert (!Thread.holdsLock(this));
        ClassLoader contextClassLoader = ServiceControllerImpl.setTCCL(listener.getClass().getClassLoader());
        try {
            switch (notification) {
                case TRANSITION: {
                    listener.transition(this, transition);
                    return;
                }
                case LISTENER_ADDED: {
                    listener.listenerAdded(this);
                    return;
                }
                case IMMEDIATE_DEPENDENCY_UNAVAILABLE: {
                    listener.immediateDependencyUnavailable(this);
                    return;
                }
                case IMMEDIATE_DEPENDENCY_AVAILABLE: {
                    listener.immediateDependencyAvailable(this);
                    return;
                }
                case TRANSITIVE_DEPENDENCY_UNAVAILABLE: {
                    listener.transitiveDependencyUnavailable(this);
                    return;
                }
                case TRANSITIVE_DEPENDENCY_AVAILABLE: {
                    listener.transitiveDependencyAvailable(this);
                    return;
                }
                case DEPENDENCY_FAILURE: {
                    listener.dependencyFailed(this);
                    return;
                }
                case DEPENDENCY_FAILURE_CLEAR: {
                    listener.dependencyFailureCleared(this);
                    return;
                }
                case REMOVE_REQUESTED: {
                    listener.serviceRemoveRequested(this);
                    return;
                }
                case REMOVE_REQUEST_CLEARED: {
                    listener.serviceRemoveRequestCleared(this);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        catch (Throwable t) {
            ServiceLogger.SERVICE.listenerFailed(t, listener);
            return;
        }
        finally {
            ServiceControllerImpl.setTCCL(contextClassLoader);
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl = this;
            synchronized (serviceControllerImpl) {
                boolean leavingRestState = this.isStableRestState();
                --this.asyncTasks;
                this.transition(tasks);
                this.asyncTasks += tasks.size();
                this.updateStabilityState(leavingRestState);
            }
            this.doExecute(tasks);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceController.Substate getSubstate() {
        ServiceControllerImpl serviceControllerImpl = this;
        synchronized (serviceControllerImpl) {
            return this.state;
        }
    }

    ServiceRegistrationImpl getPrimaryRegistration() {
        return this.primaryRegistration;
    }

    ServiceRegistrationImpl[] getAliasRegistrations() {
        return this.aliasRegistrations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dependent[][] getDependents() {
        IdentityHashSet<Dependent> dependentSet = this.primaryRegistration.getDependents();
        if (this.aliasRegistrations.length == 0) {
            IdentityHashSet<Dependent> identityHashSet = dependentSet;
            synchronized (identityHashSet) {
                return new Dependent[][]{dependentSet.toScatteredArray(NO_DEPENDENTS), this.children.toScatteredArray(NO_DEPENDENTS)};
            }
        }
        Dependent[][] dependents = new Dependent[this.aliasRegistrations.length + 2][];
        IdentityHashSet<Dependent> identityHashSet = dependentSet;
        synchronized (identityHashSet) {
            dependents[0] = dependentSet.toScatteredArray(NO_DEPENDENTS);
        }
        dependents[1] = this.children.toScatteredArray(NO_DEPENDENTS);
        for (int i = 0; i < this.aliasRegistrations.length; ++i) {
            IdentityHashSet<Dependent> aliasDependentSet;
            ServiceRegistrationImpl alias = this.aliasRegistrations[i];
            IdentityHashSet<Dependent> identityHashSet2 = aliasDependentSet = alias.getDependents();
            synchronized (identityHashSet2) {
                dependents[i + 2] = aliasDependentSet.toScatteredArray(NO_DEPENDENTS);
                continue;
            }
        }
        return dependents;
    }

    private Map<ServiceName, Dependent[]> getDependentsByDependencyName() {
        HashMap<ServiceName, Dependent[]> dependents = new HashMap<ServiceName, Dependent[]>();
        this.addDependentsByName(this.primaryRegistration, dependents);
        for (ServiceRegistrationImpl aliasRegistration : this.aliasRegistrations) {
            this.addDependentsByName(aliasRegistration, dependents);
        }
        return dependents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDependentsByName(ServiceRegistrationImpl registration, Map<ServiceName, Dependent[]> dependentsByName) {
        IdentityHashSet<Dependent> registrationDependents;
        IdentityHashSet<Dependent> identityHashSet = registrationDependents = registration.getDependents();
        synchronized (identityHashSet) {
            dependentsByName.put(registration.getName(), registrationDependents.toScatteredArray(NO_DEPENDENTS));
        }
    }

    private static <T> void doInject(ValueInjection<T> injection) {
        injection.getTarget().inject(injection.getSource().getValue());
    }

    private static ClassLoader setTCCL(ClassLoader newTCCL) {
        SecurityManager sm = System.getSecurityManager();
        SetTCCLAction setTCCLAction = new SetTCCLAction(newTCCL);
        if (sm != null) {
            return AccessController.doPrivileged(setTCCLAction);
        }
        return setTCCLAction.run();
    }

    public String toString() {
        return String.format("Controller for %s@%x", this.getName(), this.hashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeProfileInfo(char statusChar, long startNanos, long endNanos) {
        ServiceRegistrationImpl primaryRegistration = this.primaryRegistration;
        ServiceName name = primaryRegistration.getName();
        ServiceContainerImpl container = primaryRegistration.getContainer();
        Writer profileOutput = container.getProfileOutput();
        if (profileOutput != null) {
            Writer writer = profileOutput;
            synchronized (writer) {
                try {
                    long startOffset = startNanos - container.getStart();
                    long duration = endNanos - startNanos;
                    profileOutput.write(String.format("%s\t%s\t%d\t%d\n", name.getCanonicalName(), Character.valueOf(statusChar), startOffset, duration));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }

    private class StopContextImpl
    implements StopContext {
        private ContextState state = ContextState.SYNC;
        private final long startNanos;

        private StopContextImpl(long startNanos) {
            this.startNanos = startNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.ASYNC;
                } else if (this.state == ContextState.SYNC_ASYNC_COMPLETE) {
                    this.state = ContextState.COMPLETE;
                } else if (this.state == ContextState.SYNC_ASYNC_FAILED) {
                    this.state = ContextState.FAILED;
                } else if (this.state == ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state == ContextState.COMPLETE || this.state == ContextState.SYNC_ASYNC_COMPLETE) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                if (this.state == ContextState.ASYNC) {
                    this.state = ContextState.COMPLETE;
                }
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.SYNC_ASYNC_COMPLETE;
                }
            }
            for (ValueInjection injection : ServiceControllerImpl.this.injections) {
                injection.getTarget().uninject();
            }
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl2 = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl2) {
                boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('X', this.startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.asyncTasks--;
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
                ServiceControllerImpl.this.updateStabilityState(leavingRestState);
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            ClassLoader contextClassLoader = ServiceControllerImpl.setTCCL(command.getClass().getClassLoader());
            try {
                command.run();
            }
            finally {
                ServiceControllerImpl.setTCCL(contextClassLoader);
            }
        }

        @Override
        public long getElapsedTime() {
            return System.nanoTime() - ServiceControllerImpl.this.lifecycleTime;
        }
    }

    private final class ChildServiceTarget
    extends ServiceTargetImpl {
        private volatile boolean valid;

        private ChildServiceTarget(ServiceTargetImpl parentTarget) {
            super(parentTarget);
            this.valid = true;
        }

        @Override
        <T> ServiceController<T> install(ServiceBuilderImpl<T> serviceBuilder) throws ServiceRegistryException {
            if (!this.valid) {
                throw new IllegalStateException("Service target is no longer valid");
            }
            return super.install(serviceBuilder);
        }

        @Override
        protected <T> ServiceBuilder<T> createServiceBuilder(ServiceName name, Value<? extends Service<T>> value, ServiceControllerImpl<?> parent) throws IllegalArgumentException {
            return super.createServiceBuilder(name, value, ServiceControllerImpl.this);
        }

        @Override
        public ServiceTarget subTarget() {
            return new ChildServiceTarget(this);
        }
    }

    private class StartContextImpl
    implements StartContext {
        private ContextState state = ContextState.SYNC;
        private final long startNanos;

        private StartContextImpl(long startNanos) {
            this.startNanos = startNanos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void failed(StartException reason) throws IllegalStateException {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                if (reason == null) {
                    reason = new StartException("Start failed, and additionally, a null cause was supplied");
                }
                if (this.state == ContextState.COMPLETE || this.state == ContextState.FAILED || this.state == ContextState.SYNC_ASYNC_FAILED) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                if (this.state == ContextState.ASYNC) {
                    this.state = ContextState.FAILED;
                }
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.SYNC_ASYNC_FAILED;
                }
                ServiceName serviceName = ServiceControllerImpl.this.getName();
                reason.setServiceName(serviceName);
                ServiceLogger.FAIL.startFailed(reason, serviceName);
                ServiceControllerImpl.this.startException = reason;
                ServiceControllerImpl.this.failCount++;
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('F', this.startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.asyncTasks--;
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
                ServiceControllerImpl.this.updateStabilityState(leavingRestState);
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ServiceTarget getChildTarget() {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state == ContextState.COMPLETE || this.state == ContextState.FAILED) {
                    throw new IllegalStateException("Lifecycle context is no longer valid");
                }
                if (ServiceControllerImpl.this.childTarget == null) {
                    ServiceControllerImpl.this.childTarget = new ChildServiceTarget(ServiceControllerImpl.this.getServiceContainer());
                }
                return ServiceControllerImpl.this.childTarget;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void asynchronous() throws IllegalStateException {
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.ASYNC;
                } else if (this.state == ContextState.SYNC_ASYNC_COMPLETE) {
                    this.state = ContextState.COMPLETE;
                } else if (this.state == ContextState.SYNC_ASYNC_FAILED) {
                    this.state = ContextState.FAILED;
                } else if (this.state == ContextState.ASYNC) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void complete() throws IllegalStateException {
            ArrayList<Runnable> tasks = new ArrayList<Runnable>();
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                if (this.state == ContextState.COMPLETE || this.state == ContextState.FAILED || this.state == ContextState.SYNC_ASYNC_COMPLETE) {
                    throw new IllegalStateException(ServiceControllerImpl.ILLEGAL_CONTROLLER_STATE);
                }
                if (this.state == ContextState.ASYNC) {
                    this.state = ContextState.COMPLETE;
                }
                if (this.state == ContextState.SYNC) {
                    this.state = ContextState.SYNC_ASYNC_COMPLETE;
                }
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('S', this.startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.asyncTasks--;
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
                ServiceControllerImpl.this.updateStabilityState(leavingRestState);
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }

        @Override
        public long getElapsedTime() {
            return System.nanoTime() - ServiceControllerImpl.this.lifecycleTime;
        }

        @Override
        public ServiceController<?> getController() {
            return ServiceControllerImpl.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable command) {
            ClassLoader contextClassLoader = ServiceControllerImpl.setTCCL(command.getClass().getClassLoader());
            try {
                command.run();
            }
            finally {
                ServiceControllerImpl.setTCCL(contextClassLoader);
            }
        }
    }

    private class RemoveTask
    implements Runnable {
        private RemoveTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                assert (ServiceControllerImpl.this.getMode() == ServiceController.Mode.REMOVE);
                assert (ServiceControllerImpl.this.getSubstate() == ServiceController.Substate.REMOVING || ServiceControllerImpl.this.getSubstate() == ServiceController.Substate.CANCELLED);
                ServiceControllerImpl.this.primaryRegistration.clearInstance(ServiceControllerImpl.this);
                for (ServiceRegistrationImpl registration : ServiceControllerImpl.this.aliasRegistrations) {
                    registration.clearInstance(ServiceControllerImpl.this);
                }
                for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                    dependency.removeDependent(ServiceControllerImpl.this);
                }
                ServiceControllerImpl parent = ServiceControllerImpl.this.parent;
                if (parent != null) {
                    parent.removeChild(ServiceControllerImpl.this);
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyRetryingTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyRetryingTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.dependencyFailureCleared();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyFailedTask
    implements Runnable {
        private final Dependent[][] dependents;
        private final ServiceControllerImpl<?>[] children;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        DependencyFailedTask(Dependent[][] dependents, boolean removeChildren) {
            this.dependents = dependents;
            if (removeChildren && !ServiceControllerImpl.this.children.isEmpty()) {
                ServiceControllerImpl serviceControllerImpl2 = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl2) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    this.children = ServiceControllerImpl.this.children.toScatteredArray(NO_CONTROLLERS);
                    ServiceControllerImpl.this.asyncTasks++;
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
            } else {
                this.children = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.children != null) {
                    for (ServiceControllerImpl<?> child : this.children) {
                        if (child == null) continue;
                        child.setMode(ServiceController.Mode.REMOVE);
                    }
                }
                ServiceControllerImpl<?>[] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ServiceControllerImpl<?> dependentArray;
                    for (ServiceControllerImpl<?> dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.dependencyFailed();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyStoppedTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyStoppedTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyDown();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependencyStartedTask
    implements Runnable {
        private final Dependent[][] dependents;

        DependencyStartedTask(Dependent[][] dependents) {
            this.dependents = dependents;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Dependent[][] arr$ = this.dependents;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Dependent[] dependentArray;
                    for (Dependent dependent : dependentArray = arr$[i$]) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyUp();
                    }
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class ListenerTask
    implements Runnable {
        private final ListenerNotification notification;
        private final ServiceListener<? super S> listener;
        private final ServiceController.Transition transition;

        ListenerTask(ServiceListener<? super S> listener, ServiceController.Transition transition) {
            this.listener = listener;
            this.transition = transition;
            this.notification = ListenerNotification.TRANSITION;
        }

        ListenerTask(ServiceListener<? super S> listener, ListenerNotification notification) {
            this.listener = listener;
            this.transition = null;
            this.notification = notification;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!Thread.holdsLock(ServiceControllerImpl.this));
            if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                long start = System.nanoTime();
                try {
                    ServiceControllerImpl.this.invokeListener(this.listener, this.notification, this.transition);
                }
                finally {
                    ServiceControllerImpl.this.writeProfileInfo('L', start, System.nanoTime());
                }
            } else {
                ServiceControllerImpl.this.invokeListener(this.listener, this.notification, this.transition);
            }
        }
    }

    private class StopTask
    implements Runnable {
        private final boolean onlyUninject;
        private final ServiceControllerImpl<?>[] children;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        StopTask(boolean onlyUninject) {
            this.onlyUninject = onlyUninject;
            if (!onlyUninject && !ServiceControllerImpl.this.children.isEmpty()) {
                ServiceControllerImpl serviceControllerImpl2 = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl2) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    this.children = ServiceControllerImpl.this.children.toScatteredArray(NO_CONTROLLERS);
                    ServiceControllerImpl.this.asyncTasks++;
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
            } else {
                this.children = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block23: {
                assert (!Thread.holdsLock(ServiceControllerImpl.this));
                ServiceName serviceName = ServiceControllerImpl.this.primaryRegistration.getName();
                long startNanos = System.nanoTime();
                StopContextImpl context = new StopContextImpl(startNanos);
                boolean ok = false;
                try {
                    if (this.onlyUninject) break block23;
                    try {
                        Service service;
                        if (this.children != null) {
                            for (ServiceControllerImpl<?> child : this.children) {
                                if (child == null) continue;
                                child.setMode(ServiceController.Mode.REMOVE);
                            }
                        }
                        if ((service = (Service)ServiceControllerImpl.this.serviceValue.getValue()) != null) {
                            this.stopService(service, context);
                            ok = true;
                            break block23;
                        }
                        ServiceLogger.ROOT.stopServiceMissing(serviceName);
                    }
                    catch (Throwable t) {
                        ServiceLogger.FAIL.stopFailed(t, serviceName);
                    }
                }
                finally {
                    ArrayList<Runnable> tasks;
                    ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                    synchronized (serviceControllerImpl) {
                        if (ok && context.state != ContextState.SYNC) {
                            return;
                        }
                        context.state = ContextState.COMPLETE;
                    }
                    this.uninject(serviceName, ServiceControllerImpl.this.injections);
                    this.uninject(serviceName, ServiceControllerImpl.this.outInjections);
                    serviceControllerImpl = ServiceControllerImpl.this;
                    synchronized (serviceControllerImpl) {
                        boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                        if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                            ServiceControllerImpl.this.writeProfileInfo('X', startNanos, System.nanoTime());
                        }
                        ServiceControllerImpl.this.asyncTasks--;
                        tasks = new ArrayList<Runnable>();
                        ServiceControllerImpl.this.transition(tasks);
                        ServiceControllerImpl.this.asyncTasks += tasks.size();
                        ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                    }
                    ServiceControllerImpl.this.doExecute(tasks);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopService(Service<? extends S> service, StopContext context) {
            ClassLoader contextClassLoader = ServiceControllerImpl.setTCCL(service.getClass().getClassLoader());
            try {
                service.stop(context);
            }
            finally {
                ServiceControllerImpl.setTCCL(contextClassLoader);
            }
        }

        private void uninject(ServiceName serviceName, ValueInjection<?>[] injections) {
            for (ValueInjection<?> injection : injections) {
                try {
                    injection.getTarget().uninject();
                }
                catch (Throwable t) {
                    ServiceLogger.ROOT.uninjectFailed(t, serviceName, injection);
                }
            }
        }
    }

    private class StartTask
    implements Runnable {
        private final boolean doInjection;

        StartTask(boolean doInjection) {
            this.doInjection = doInjection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!Thread.holdsLock(ServiceControllerImpl.this));
            ServiceName serviceName = ServiceControllerImpl.this.primaryRegistration.getName();
            long startNanos = System.nanoTime();
            StartContextImpl context = new StartContextImpl(startNanos);
            try {
                this.performInjections();
                Service service = (Service)ServiceControllerImpl.this.serviceValue.getValue();
                if (service == null) {
                    throw new IllegalArgumentException("Service is null");
                }
                this.startService(service, context);
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    if (context.state != ContextState.SYNC) {
                        return;
                    }
                    context.state = ContextState.COMPLETE;
                    if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                        ServiceControllerImpl.this.writeProfileInfo('S', startNanos, System.nanoTime());
                    }
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                this.performOutInjections(serviceName);
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (StartException e) {
                e.setServiceName(serviceName);
                this.startFailed(e, serviceName, context, startNanos);
            }
            catch (Throwable t) {
                StartException e = new StartException("Failed to start service", t, serviceName);
                this.startFailed(e, serviceName, context, startNanos);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performInjections() {
            if (this.doInjection) {
                int i;
                int injectionsLength = ServiceControllerImpl.this.injections.length;
                boolean ok = false;
                try {
                    for (i = 0; i < injectionsLength; ++i) {
                        ValueInjection injection = ServiceControllerImpl.this.injections[i];
                        ServiceControllerImpl.doInject(injection);
                    }
                    ok = true;
                }
                finally {
                    if (!ok) {
                        while (i >= 0) {
                            ServiceControllerImpl.this.injections[i].getTarget().uninject();
                            --i;
                        }
                    }
                }
            }
        }

        private void performOutInjections(ServiceName serviceName) {
            if (this.doInjection) {
                int injectionsLength = ServiceControllerImpl.this.outInjections.length;
                for (int i = 0; i < injectionsLength; ++i) {
                    ValueInjection injection = ServiceControllerImpl.this.outInjections[i];
                    try {
                        ServiceControllerImpl.doInject(injection);
                        continue;
                    }
                    catch (Throwable t) {
                        ServiceLogger.SERVICE.exceptionAfterComplete(t, serviceName);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startService(Service<? extends S> service, StartContext context) throws StartException {
            ClassLoader contextClassLoader = ServiceControllerImpl.setTCCL(service.getClass().getClassLoader());
            try {
                service.start(context);
            }
            finally {
                ServiceControllerImpl.setTCCL(contextClassLoader);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startFailed(StartException e, ServiceName serviceName, StartContextImpl context, long startNanos) {
            ArrayList<Runnable> tasks;
            ServiceLogger.FAIL.startFailed(e, serviceName);
            ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
            synchronized (serviceControllerImpl) {
                boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                ContextState oldState = context.state;
                if (oldState != ContextState.SYNC && oldState != ContextState.ASYNC) {
                    ServiceLogger.FAIL.exceptionAfterComplete(e, serviceName);
                    return;
                }
                context.state = ContextState.FAILED;
                ServiceControllerImpl.this.startException = e;
                if (ServiceContainerImpl.PROFILE_OUTPUT != null) {
                    ServiceControllerImpl.this.writeProfileInfo('F', startNanos, System.nanoTime());
                }
                ServiceControllerImpl.this.failCount++;
                ServiceControllerImpl.this.asyncTasks--;
                tasks = new ArrayList<Runnable>();
                ServiceControllerImpl.this.transition(tasks);
                ServiceControllerImpl.this.asyncTasks += tasks.size();
                ServiceControllerImpl.this.updateStabilityState(leavingRestState);
            }
            ServiceControllerImpl.this.doExecute(tasks);
        }
    }

    private class ServiceAvailableTask
    implements Runnable {
        private final Map<ServiceName, Dependent[]> dependents;
        private final Dependent[] children;

        ServiceAvailableTask() {
            this.dependents = ServiceControllerImpl.this.getDependentsByDependencyName();
            this.children = ServiceControllerImpl.this.children.toScatteredArray(NO_DEPENDENTS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Map.Entry<ServiceName, Dependent[]> dependentEntry : this.dependents.entrySet()) {
                    ServiceName serviceName = dependentEntry.getKey();
                    for (Dependent dependent : dependentEntry.getValue()) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyAvailable(serviceName);
                    }
                }
                ServiceName primaryRegistrationName = ServiceControllerImpl.this.primaryRegistration.getName();
                for (Dependent child : this.children) {
                    if (child == null) continue;
                    child.immediateDependencyAvailable(primaryRegistrationName);
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class ServiceUnavailableTask
    implements Runnable {
        private final Map<ServiceName, Dependent[]> dependents;
        private final Dependent[] children;

        ServiceUnavailableTask() {
            this.dependents = ServiceControllerImpl.this.getDependentsByDependencyName();
            this.children = ServiceControllerImpl.this.children.toScatteredArray(NO_DEPENDENTS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Map.Entry<ServiceName, Dependent[]> dependentEntry : this.dependents.entrySet()) {
                    ServiceName serviceName = dependentEntry.getKey();
                    for (Dependent dependent : dependentEntry.getValue()) {
                        if (dependent == null) continue;
                        dependent.immediateDependencyUnavailable(serviceName);
                    }
                }
                ServiceName primaryRegistrationName = ServiceControllerImpl.this.primaryRegistration.getName();
                for (Dependent child : this.children) {
                    if (child == null) continue;
                    child.immediateDependencyUnavailable(primaryRegistrationName);
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependentStartedTask
    implements Runnable {
        private DependentStartedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                    dependency.dependentStarted();
                }
                ServiceControllerImpl parent = ServiceControllerImpl.this.parent;
                if (parent != null) {
                    parent.dependentStarted();
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DependentStoppedTask
    implements Runnable {
        private DependentStoppedTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                for (Dependency dependency : ServiceControllerImpl.this.dependencies) {
                    dependency.dependentStopped();
                }
                ServiceControllerImpl parent = ServiceControllerImpl.this.parent;
                if (parent != null) {
                    parent.dependentStopped();
                }
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class UndemandDependenciesTask
    implements Runnable {
        private UndemandDependenciesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServiceControllerImpl.this.doUndemandDependencies();
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    private class DemandDependenciesTask
    implements Runnable {
        private DemandDependenciesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ServiceControllerImpl.this.doDemandDependencies();
                ArrayList<Runnable> tasks = new ArrayList<Runnable>();
                ServiceControllerImpl serviceControllerImpl = ServiceControllerImpl.this;
                synchronized (serviceControllerImpl) {
                    boolean leavingRestState = ServiceControllerImpl.this.isStableRestState();
                    ServiceControllerImpl.this.asyncTasks--;
                    ServiceControllerImpl.this.transition(tasks);
                    ServiceControllerImpl.this.asyncTasks += tasks.size();
                    ServiceControllerImpl.this.updateStabilityState(leavingRestState);
                }
                ServiceControllerImpl.this.doExecute(tasks);
            }
            catch (Throwable t) {
                ServiceLogger.SERVICE.internalServiceError(t, ServiceControllerImpl.this.primaryRegistration.getName());
            }
        }
    }

    static enum ContextState {
        SYNC_ASYNC_COMPLETE,
        SYNC_ASYNC_FAILED,
        SYNC,
        ASYNC,
        COMPLETE,
        FAILED;

    }

    private static enum ListenerNotification {
        LISTENER_ADDED,
        TRANSITION,
        DEPENDENCY_FAILURE,
        DEPENDENCY_FAILURE_CLEAR,
        IMMEDIATE_DEPENDENCY_UNAVAILABLE,
        IMMEDIATE_DEPENDENCY_AVAILABLE,
        TRANSITIVE_DEPENDENCY_UNAVAILABLE,
        TRANSITIVE_DEPENDENCY_AVAILABLE,
        REMOVE_REQUESTED,
        REMOVE_REQUEST_CLEARED;

    }
}

