/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

class ModelControllerLock {
    private final Sync sync = new Sync();

    ModelControllerLock() {
    }

    void lock(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquire(permit);
    }

    void lockShared(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireShared(permit);
    }

    boolean lock(Integer permit, long timeout, TimeUnit unit) {
        boolean result = false;
        try {
            result = this.lockInterruptibly(permit, timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    boolean lockShared(Integer permit, long timeout, TimeUnit unit) {
        boolean result = false;
        try {
            result = this.lockSharedInterruptibly(permit, timeout, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result;
    }

    void lockInterruptibly(Integer permit) throws InterruptedException {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireInterruptibly(permit);
    }

    void lockSharedInterruptibly(Integer permit) throws InterruptedException {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.acquireSharedInterruptibly(permit);
    }

    boolean lockInterruptibly(Integer permit, long timeout, TimeUnit unit) throws InterruptedException {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        return this.sync.tryAcquireNanos(permit, unit.toNanos(timeout));
    }

    boolean lockSharedInterruptibly(Integer permit, long timeout, TimeUnit unit) throws InterruptedException {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        return this.sync.tryAcquireSharedNanos(permit, unit.toNanos(timeout));
    }

    void unlock(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.release(permit);
    }

    void unlockShared(Integer permit) {
        if (permit == null) {
            throw new IllegalArgumentException();
        }
        this.sync.releaseShared(permit);
    }

    boolean detectDeadlockAndGetLock(int permit) {
        return this.sync.tryAcquire(permit);
    }

    private class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 1L;
        private static final int EXCLUSIVE_SHIFT = 30;
        private static final int COUNT_MASK = 0x3FFFFFFF;
        private static final int MAX_COUNT = 0x3FFFFFFF;
        private static final short NOT_LOCKED = 0;
        private static final short EXCLUSIVE = 1;
        private static final short SHARED = 2;
        private int permitHolder;

        private Sync() {
        }

        @Override
        protected final boolean tryAcquire(int permit) {
            return this.internalAcquire(permit, true) == 1;
        }

        @Override
        protected final int tryAcquireShared(int permit) {
            return this.internalAcquire(permit, false);
        }

        @Override
        protected final boolean tryRelease(int permit) {
            return this.internalRelease(permit, true);
        }

        @Override
        protected final boolean tryReleaseShared(int permit) {
            return this.internalRelease(permit, false);
        }

        private void setCurrentPermitHolder(int permit) {
            this.permitHolder = permit;
        }

        private int getCurrentPermitHolder() {
            return this.permitHolder;
        }

        private int getCount(int value) {
            return value & 0x3FFFFFFF;
        }

        private int getLockMode(int value) {
            return value >>> 30;
        }

        private int makeState(int lockMode, int count) {
            assert (lockMode == 1 || lockMode == 2);
            assert (count > 0);
            if (count < 0 || count > 0x3FFFFFFF) {
                throw new IllegalMonitorStateException("Maximum lock count exceeded.");
            }
            int state = lockMode << 30 | count & 0x3FFFFFFF;
            assert (count == this.getCount(state));
            assert (lockMode == this.getLockMode(state));
            return state;
        }

        private int internalAcquire(int permit, boolean exclusive) {
            short next;
            int newState;
            int state;
            do {
                state = this.getState();
                int count = this.getCount(state);
                int mode = this.getLockMode(state);
                if (mode == 2 && exclusive) {
                    return -1;
                }
                if (!(mode != 1 || this.getCurrentPermitHolder() == permit && exclusive)) {
                    return -1;
                }
                next = (short)(count + 1);
                if (next >= 0) continue;
                throw new IllegalMonitorStateException("Maximum lock count exceeded.");
            } while (!this.compareAndSetState(state, newState = this.makeState(exclusive ? 1 : 2, next)));
            if (exclusive) {
                this.setCurrentPermitHolder(permit);
            }
            return 1;
        }

        private boolean internalRelease(int permit, boolean exclusive) {
            int next;
            int newState;
            int state;
            block5: do {
                state = this.getState();
                int mode = this.getLockMode(state);
                next = this.getCount(state) - 1;
                if (next < 0) {
                    throw new IllegalMonitorStateException("Lock count exceeded.");
                }
                switch (mode) {
                    case 0: {
                        throw new IllegalMonitorStateException(exclusive ? "Write Lock not held." : "Read Lock not held.");
                    }
                    case 1: {
                        if (!exclusive) {
                            throw new IllegalMonitorStateException("Read lock release not allowed in exclusive mode.");
                        }
                        if (this.getCurrentPermitHolder() == permit) continue block5;
                        return false;
                    }
                    case 2: {
                        if (!exclusive) continue block5;
                        throw new IllegalMonitorStateException("Write lock release not allowed in shared mode.");
                    }
                    default: {
                        throw new IllegalMonitorStateException("Unknown lock mode.");
                    }
                }
            } while (!this.compareAndSetState(state, newState = next == 0 ? 0 : this.makeState(exclusive ? 1 : 2, next)));
            return next == 0;
        }
    }
}

