/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.protocol.mgmt;

import infinispan.org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import infinispan.org.jboss.as.protocol.mgmt.ProtocolUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ManagementRequestHeader
extends ManagementProtocolHeader {
    private int requestId;
    private int batchId;
    private byte operationId;
    private boolean oneWay;

    public ManagementRequestHeader(int version, int requestId, int batchId, byte operationId) {
        super(version);
        this.requestId = requestId;
        this.batchId = batchId;
        this.operationId = operationId;
    }

    ManagementRequestHeader(int version, DataInput input) throws IOException {
        super(version);
        this.read(input);
    }

    public void read(DataInput input) throws IOException {
        ProtocolUtils.expectHeader(input, 16);
        this.requestId = input.readInt();
        ProtocolUtils.expectHeader(input, 17);
        this.batchId = input.readInt();
        ProtocolUtils.expectHeader(input, 18);
        this.operationId = input.readByte();
        ProtocolUtils.expectHeader(input, 19);
        this.oneWay = input.readBoolean();
        ProtocolUtils.expectHeader(input, 20);
    }

    @Override
    public void write(DataOutput output) throws IOException {
        super.write(output);
        output.write(16);
        output.writeInt(this.requestId);
        output.write(17);
        output.writeInt(this.batchId);
        output.write(18);
        output.write(this.operationId);
        output.write(19);
        output.writeBoolean(this.oneWay);
        output.write(20);
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getBatchId() {
        return this.batchId;
    }

    public byte getOperationId() {
        return this.operationId;
    }

    @Override
    public byte getType() {
        return 2;
    }
}

