/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import java.io.InputStream;
import java.util.concurrent.atomic.AtomicInteger;
import net.jcip.annotations.Immutable;
import org.infinispan.client.hotrod.configuration.ClientIntelligence;
import org.infinispan.client.hotrod.impl.VersionedMetadataImpl;
import org.infinispan.client.hotrod.impl.operations.AbstractKeyOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.protocol.HeaderParams;
import org.infinispan.client.hotrod.impl.protocol.HotRodConstants;
import org.infinispan.client.hotrod.impl.transport.Transport;
import org.infinispan.client.hotrod.impl.transport.TransportFactory;

@Immutable
public class GetStreamOperation<T extends InputStream>
extends AbstractKeyOperation<T> {
    private final int offset;
    private boolean retryable;

    public GetStreamOperation(Codec codec, TransportFactory transportFactory, Object key, byte[] keyBytes, int offset, byte[] cacheName, AtomicInteger topologyId, int flags, ClientIntelligence clientIntelligence) {
        super(codec, transportFactory, key, keyBytes, cacheName, topologyId, flags, clientIntelligence);
        this.offset = offset;
        this.retryable = true;
    }

    @Override
    public T executeOperation(Transport transport) {
        HeaderParams params = this.writeHeader(transport, (short)55);
        transport.writeArray(this.keyBytes);
        transport.writeVInt(this.offset);
        transport.flush();
        short status = this.readHeaderAndValidate(transport, params);
        T result = null;
        if (HotRodConstants.isNotExist(status)) {
            result = null;
        } else if (HotRodConstants.isSuccess(status)) {
            this.retryable = false;
            short flags = transport.readByte();
            long creation = -1L;
            int lifespan = -1;
            long lastUsed = -1L;
            int maxIdle = -1;
            if ((flags & 1) != 1) {
                creation = transport.readLong();
                lifespan = transport.readVInt();
            }
            if ((flags & 2) != 2) {
                lastUsed = transport.readLong();
                maxIdle = transport.readVInt();
            }
            long version = transport.readLong();
            transport.setBusy(true);
            result = this.codec.readAsStream(transport, new VersionedMetadataImpl(creation, lifespan, lastUsed, maxIdle, version), () -> {
                transport.setBusy(false);
                transport.getTransportFactory().releaseTransport(transport);
            });
        }
        return result;
    }

    @Override
    protected boolean shouldRetry(int retryCount) {
        return this.retryable && super.shouldRetry(retryCount);
    }
}

