/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.access.constraint;

public class ApplicationTypeConfig {
    public static final ApplicationTypeConfig DEPLOYMENT = new ApplicationTypeConfig("deployment", true);
    private final boolean core;
    private final String subsystem;
    private final String name;
    private final boolean application;
    private volatile Boolean configuredApplication;

    public ApplicationTypeConfig(String subsystem, String name) {
        this(subsystem, name, false);
    }

    public ApplicationTypeConfig(String subsystem, String name, boolean application) {
        assert (subsystem != null) : "subsystem is null";
        assert (name != null) : "name is null";
        this.subsystem = subsystem;
        this.name = name;
        this.application = application;
        this.core = false;
    }

    private ApplicationTypeConfig(String name, boolean application) {
        this.core = true;
        this.subsystem = null;
        this.name = name;
        this.application = application;
    }

    public boolean isCore() {
        return this.core;
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultApplication() {
        return this.application;
    }

    public Boolean getConfiguredApplication() {
        return this.configuredApplication;
    }

    public boolean isApplicationType() {
        Boolean app = this.configuredApplication;
        return app == null ? this.application : app;
    }

    public void setConfiguredApplication(Boolean configuredApplication) {
        this.configuredApplication = configuredApplication;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof ApplicationTypeConfig && this.getKey().equals(((ApplicationTypeConfig)obj).getKey());
    }

    Key getKey() {
        return new Key();
    }

    boolean isCompatibleWith(ApplicationTypeConfig other) {
        return !this.equals(other) || this.application == other.application;
    }

    class Key {
        private final ApplicationTypeConfig typeConfig;

        Key() {
            this.typeConfig = ApplicationTypeConfig.this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key thatKey = (Key)o;
            ApplicationTypeConfig that = thatKey.typeConfig;
            return ApplicationTypeConfig.this.core == that.core && ApplicationTypeConfig.this.name.equals(that.name) && !(ApplicationTypeConfig.this.subsystem == null ? that.subsystem != null : !ApplicationTypeConfig.this.subsystem.equals(that.subsystem));
        }

        public int hashCode() {
            int result = ApplicationTypeConfig.this.core ? 1 : 0;
            result = 31 * result + (ApplicationTypeConfig.this.subsystem != null ? ApplicationTypeConfig.this.subsystem.hashCode() : 0);
            result = 31 * result + ApplicationTypeConfig.this.name.hashCode();
            return result;
        }
    }
}

