/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.transform.description;

import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.as.controller.transform.ChainedTransformationTools;
import infinispan.org.jboss.as.controller.transform.OperationResultTransformer;
import infinispan.org.jboss.as.controller.transform.OperationTransformer;
import infinispan.org.jboss.as.controller.transform.PathAddressTransformer;
import infinispan.org.jboss.as.controller.transform.ResourceTransformationContext;
import infinispan.org.jboss.as.controller.transform.ResourceTransformer;
import infinispan.org.jboss.as.controller.transform.TransformationContext;
import infinispan.org.jboss.as.controller.transform.description.AbstractDescription;
import infinispan.org.jboss.as.controller.transform.description.ChainedPlaceholderResolver;
import infinispan.org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilderImpl;
import infinispan.org.jboss.as.controller.transform.description.TransformationDescription;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ChainedTransformingDescription
extends AbstractDescription
implements TransformationDescription,
ResourceTransformer,
OperationTransformer {
    private final LinkedHashMap<ChainedTransformationDescriptionBuilderImpl.ModelVersionPair, ChainedPlaceholderResolver> placeholderResolvers;

    ChainedTransformingDescription(PathElement pathElement, LinkedHashMap<ChainedTransformationDescriptionBuilderImpl.ModelVersionPair, ChainedPlaceholderResolver> placeholderResolvers) {
        super(pathElement, PathAddressTransformer.DEFAULT, true);
        this.placeholderResolvers = placeholderResolvers;
    }

    @Override
    public OperationTransformer.TransformedOperation transformOperation(TransformationContext context, PathAddress address, ModelNode operation) throws OperationFailedException {
        ChainedPlaceholderResolver resolver;
        assert (context instanceof ResourceTransformationContext) : "Wrong context type";
        ResourceTransformationContext currentCtx = (ResourceTransformationContext)context;
        ArrayList<OperationTransformer.TransformedOperation> delegates = new ArrayList<OperationTransformer.TransformedOperation>();
        ModelNode currentOp = operation;
        Iterator<Map.Entry<ChainedTransformationDescriptionBuilderImpl.ModelVersionPair, ChainedPlaceholderResolver>> it = this.placeholderResolvers.entrySet().iterator();
        if (it.hasNext()) {
            resolver = it.next().getValue();
            currentCtx = ChainedTransformationTools.initialiseChain(currentCtx, resolver);
            PathAddress addr = ChainedTransformationTools.transformAddress(PathAddress.pathAddress(currentOp.require("address")), currentCtx.getTarget());
            currentOp.get("address").set(addr.toModelNode());
            OperationTransformer transformer = currentCtx.getTarget().resolveTransformer(currentCtx, address, currentOp.require("operation").asString());
            OperationTransformer.TransformedOperation transformed = transformer.transformOperation(currentCtx, address, currentOp);
            currentOp = transformed.getTransformedOperation();
            delegates.add(transformed);
        }
        while (it.hasNext() && currentOp != null) {
            resolver = it.next().getValue();
            currentCtx = ChainedTransformationTools.nextInChainOperation(currentCtx, resolver);
            PathAddress currentAddress = PathAddress.pathAddress(currentOp.require("address"));
            PathAddress addr = ChainedTransformationTools.transformAddress(currentAddress, currentCtx.getTarget());
            currentOp.get("address").set(addr.toModelNode());
            OperationTransformer transformer = currentCtx.getTarget().resolveTransformer(currentCtx, currentAddress, currentOp.require("operation").asString());
            OperationTransformer.TransformedOperation transformed = transformer.transformOperation(currentCtx, address, currentOp);
            currentOp = transformed.getTransformedOperation();
            delegates.add(transformed);
        }
        return new ChainedTransformedOperation(currentOp, delegates.toArray(new OperationTransformer.TransformedOperation[delegates.size()]));
    }

    @Override
    public void transformResource(ResourceTransformationContext context, PathAddress address, Resource resource) throws OperationFailedException {
        ChainedPlaceholderResolver resolver;
        if (resource.isProxy() || resource.isRuntime()) {
            return;
        }
        ResourceTransformationContext current = context;
        Iterator<Map.Entry<ChainedTransformationDescriptionBuilderImpl.ModelVersionPair, ChainedPlaceholderResolver>> it = this.placeholderResolvers.entrySet().iterator();
        if (it.hasNext()) {
            resolver = it.next().getValue();
            current = ChainedTransformationTools.initialiseChain(current, resolver);
            resolver.getDescription().getResourceTransformer().transformResource(current, address, resource);
        }
        while (it.hasNext()) {
            resolver = it.next().getValue();
            current = ChainedTransformationTools.nextInChainResource(current, resolver);
            try {
                Resource currentResource = current.readResourceFromRoot(address);
                resolver.getDescription().getResourceTransformer().transformResource(current, address, currentResource);
            }
            catch (Resource.NoSuchResourceException e) {}
        }
        Resource transformed = current.getTransformedRoot();
        Resource originalTransformed = context.getTransformedRoot();
        this.copy(transformed, originalTransformed, address);
    }

    @Override
    public PathAddressTransformer getPathAddressTransformer() {
        return PathAddressTransformer.DEFAULT;
    }

    @Override
    public OperationTransformer getOperationTransformer() {
        return this;
    }

    @Override
    public ResourceTransformer getResourceTransformer() {
        return this;
    }

    @Override
    public Map<String, OperationTransformer> getOperationTransformers() {
        return Collections.emptyMap();
    }

    @Override
    public List<TransformationDescription> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getDiscardedOperations() {
        return Collections.emptySet();
    }

    @Override
    public boolean isPlaceHolder() {
        return true;
    }

    private void copy(Resource src, Resource dest, PathAddress address) {
        PathAddress parentAddress = address.size() > 1 ? address.subAddress(0, address.size() - 1) : PathAddress.EMPTY_ADDRESS;
        PathElement childElement = address.getLastElement();
        Resource source = src.navigate(parentAddress);
        Resource destination = dest.navigate(parentAddress);
        Resource sourceChild = source.getChild(childElement);
        if (sourceChild != null) {
            Resource destChild = Resource.Factory.create();
            destination.registerChild(childElement, destChild);
            this.copy(sourceChild, destChild);
        }
    }

    private void copy(Resource src, Resource dest) {
        dest.getModel().set(src.getModel());
        for (String type : src.getChildTypes()) {
            for (Resource.ResourceEntry entry : src.getChildren(type)) {
                Resource added = Resource.Factory.create();
                dest.registerChild(PathElement.pathElement(type, entry.getName()), added);
                this.copy(entry, added);
            }
        }
    }

    private PathAddress transformAddress(PathAddress original, ResourceTransformationContext context) {
        return ChainedTransformationTools.transformAddress(original, context.getTarget());
    }

    private static class ChainedTransformedOperation
    extends OperationTransformer.TransformedOperation {
        private OperationTransformer.TransformedOperation[] delegates;
        private volatile String failure;
        private volatile boolean initialized;

        public ChainedTransformedOperation(ModelNode transformedOperation, OperationTransformer.TransformedOperation ... delegates) {
            super(transformedOperation, null);
            this.delegates = delegates;
        }

        @Override
        public ModelNode getTransformedOperation() {
            return super.getTransformedOperation();
        }

        @Override
        public OperationResultTransformer getResultTransformer() {
            return this;
        }

        @Override
        public boolean rejectOperation(ModelNode preparedResult) {
            for (OperationTransformer.TransformedOperation delegate : this.delegates) {
                if (!delegate.rejectOperation(preparedResult)) continue;
                this.failure = delegate.getFailureDescription();
                this.initialized = true;
                return true;
            }
            return false;
        }

        @Override
        public String getFailureDescription() {
            if (!this.initialized) {
                for (OperationTransformer.TransformedOperation delegate : this.delegates) {
                    String failure = delegate.getFailureDescription();
                    if (failure == null) continue;
                    return failure;
                }
            }
            return this.failure;
        }

        @Override
        public ModelNode transformResult(ModelNode result) {
            ModelNode currentResult = result;
            for (int i = this.delegates.length - 1; i >= 0; --i) {
                currentResult = this.delegates[i].transformResult(currentResult);
            }
            return currentResult;
        }
    }
}

