/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.AccessAuditContext;
import infinispan.org.jboss.as.controller.access.Caller;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.security.auth.Subject;
import org.wildfly.security.manager.WildFlySecurityManager;

class SecurityActions {
    private SecurityActions() {
    }

    static Caller getCaller(Caller currentCaller) {
        AccessControlContext acc = AccessController.getContext();
        return SecurityActions.createCallerActions().getCaller(acc, currentCaller);
    }

    static Subject getSubject(Caller caller) {
        return SecurityActions.createCallerActions().getSubject(caller);
    }

    static AccessAuditContext currentAccessAuditContext() {
        return SecurityActions.createAccessAuditContextActions().currentContext();
    }

    private static AccessAuditContextActions createAccessAuditContextActions() {
        return WildFlySecurityManager.isChecking() ? AccessAuditContextActions.PRIVILEGED : AccessAuditContextActions.NON_PRIVILEGED;
    }

    private static CallerActions createCallerActions() {
        return WildFlySecurityManager.isChecking() ? CallerActions.PRIVILEGED : CallerActions.NON_PRIVILEGED;
    }

    private static interface CallerActions {
        public static final CallerActions NON_PRIVILEGED = new CallerActions(){

            @Override
            public Caller getCaller(AccessControlContext acc, Caller currentCaller) {
                Subject subject = Subject.getSubject(acc);
                if (currentCaller == null || subject != currentCaller.getSubject()) {
                    if (subject != null) {
                        subject.setReadOnly();
                    }
                    return Caller.createCaller(subject);
                }
                return currentCaller;
            }

            @Override
            public Subject getSubject(Caller caller) {
                return caller.getSubject();
            }
        };
        public static final CallerActions PRIVILEGED = new CallerActions(){

            @Override
            public Caller getCaller(final AccessControlContext acc, final Caller currentCaller) {
                return AccessController.doPrivileged(new PrivilegedAction<Caller>(){

                    @Override
                    public Caller run() {
                        return NON_PRIVILEGED.getCaller(acc, currentCaller);
                    }
                });
            }

            @Override
            public Subject getSubject(final Caller caller) {
                return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

                    @Override
                    public Subject run() {
                        return NON_PRIVILEGED.getSubject(caller);
                    }
                });
            }
        };

        public Caller getCaller(AccessControlContext var1, Caller var2);

        public Subject getSubject(Caller var1);
    }

    private static interface AccessAuditContextActions {
        public static final AccessAuditContextActions NON_PRIVILEGED = new AccessAuditContextActions(){

            @Override
            public AccessAuditContext currentContext() {
                return AccessAuditContext.currentAccessAuditContext();
            }
        };
        public static final AccessAuditContextActions PRIVILEGED = new AccessAuditContextActions(){
            private final PrivilegedAction<AccessAuditContext> PRIVILEGED_ACTION = new PrivilegedAction<AccessAuditContext>(){

                @Override
                public AccessAuditContext run() {
                    return NON_PRIVILEGED.currentContext();
                }
            };

            @Override
            public AccessAuditContext currentContext() {
                return AccessController.doPrivileged(this.PRIVILEGED_ACTION);
            }
        };

        public AccessAuditContext currentContext();
    }
}

