/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller;

import infinispan.org.jboss.as.controller.AttributeDefinition;
import infinispan.org.jboss.as.controller.AttributeParser;
import infinispan.org.jboss.as.controller.PropertiesAttributeDefinition;
import infinispan.org.jboss.as.controller.parsing.ParseUtils;
import infinispan.org.jboss.dmr.ModelNode;
import java.util.Collections;
import javax.xml.stream.XMLStreamException;
import org.jboss.staxmapper.XMLExtendedStreamReader;

public interface AttributeParsers {
    public static final AttributeParser PROPERTIES_WRAPPED = new PropertiesParser();
    public static final AttributeParser PROPERTIES_UNWRAPPED = new PropertiesParser(false);

    public static class PropertiesParser
    extends AttributeParser {
        private final String wrapperElement;
        private final String elementName;
        private final boolean wrapElement;

        public PropertiesParser(String wrapperElement, String elementName, boolean wrapElement) {
            this.wrapperElement = wrapperElement;
            this.elementName = elementName == null ? "property" : elementName;
            this.wrapElement = wrapElement;
        }

        public PropertiesParser(String wrapperElement, boolean wrapElement) {
            this(wrapperElement, "property", wrapElement);
        }

        public PropertiesParser(boolean wrapElement) {
            this(null, null, wrapElement);
        }

        public PropertiesParser(String wrapperElement) {
            this(wrapperElement, null, true);
        }

        public PropertiesParser() {
            this(null, "property", true);
        }

        @Override
        public boolean isParseAsElement() {
            return true;
        }

        @Override
        public String getXmlName(AttributeDefinition attribute) {
            return this.wrapElement ? (this.wrapperElement != null ? this.wrapperElement : attribute.getXmlName()) : this.elementName;
        }

        @Override
        public void parseElement(AttributeDefinition attribute, XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
            assert (attribute instanceof PropertiesAttributeDefinition);
            PropertiesAttributeDefinition property = (PropertiesAttributeDefinition)attribute;
            String wrapper = this.wrapperElement == null ? property.getName() : this.wrapperElement;
            operation.get(attribute.getName()).setEmptyObject();
            if (this.wrapElement) {
                if (!reader.getLocalName().equals(wrapper)) {
                    throw ParseUtils.unexpectedElement(reader, Collections.singleton(wrapper));
                }
                if (reader.nextTag() == 2) {
                    return;
                }
            }
            do {
                if (!this.elementName.equals(reader.getLocalName())) {
                    throw ParseUtils.unexpectedElement(reader, Collections.singleton(this.elementName));
                }
                property.parse(reader, operation);
            } while (reader.hasNext() && reader.nextTag() != 2 && reader.getLocalName().equals(this.elementName));
            if (this.wrapElement && reader.getEventType() != 2) {
                throw ParseUtils.unexpectedElement(reader, Collections.singleton(this.elementName));
            }
        }
    }
}

