/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.threads;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class ThreadNameInfo {
    private final long globalThreadSequenceNum;
    private final long perFactoryThreadSequenceNum;
    private final long factorySequenceNum;
    private static final Pattern searchPattern = Pattern.compile("([^%]+)|%.");

    ThreadNameInfo(long globalThreadSequenceNum, long perFactoryThreadSequenceNum, long factorySequenceNum) {
        this.globalThreadSequenceNum = globalThreadSequenceNum;
        this.perFactoryThreadSequenceNum = perFactoryThreadSequenceNum;
        this.factorySequenceNum = factorySequenceNum;
    }

    public long getGlobalThreadSequenceNum() {
        return this.globalThreadSequenceNum;
    }

    public long getPerFactoryThreadSequenceNum() {
        return this.perFactoryThreadSequenceNum;
    }

    public long getFactorySequenceNum() {
        return this.factorySequenceNum;
    }

    public String format(Thread thread, String formatString) {
        StringBuilder builder = new StringBuilder(formatString.length() * 5);
        ThreadGroup group = thread.getThreadGroup();
        Matcher matcher = searchPattern.matcher(formatString);
        while (matcher.find()) {
            if (matcher.group(1) != null) {
                builder.append(matcher.group());
                continue;
            }
            switch (matcher.group().charAt(1)) {
                case '%': {
                    builder.append('%');
                    break;
                }
                case 't': {
                    builder.append(this.perFactoryThreadSequenceNum);
                    break;
                }
                case 'g': {
                    builder.append(this.globalThreadSequenceNum);
                    break;
                }
                case 'f': {
                    builder.append(this.factorySequenceNum);
                    break;
                }
                case 'p': {
                    if (group == null) break;
                    ThreadNameInfo.appendGroupPath(group, builder);
                    break;
                }
                case 'i': {
                    builder.append(thread.getId());
                }
                case 'G': {
                    if (group == null) break;
                    builder.append(group.getName());
                }
            }
        }
        return builder.toString();
    }

    private static void appendGroupPath(ThreadGroup group, StringBuilder builder) {
        ThreadGroup parent = group.getParent();
        if (parent != null) {
            ThreadNameInfo.appendGroupPath(parent, builder);
            builder.append(':');
        }
        builder.append(group.getName());
    }
}

