/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.client.helpers.domain;

import infinispan.org.jboss.as.controller.client.ModelControllerClient;
import infinispan.org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import infinispan.org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import infinispan.org.jboss.as.controller.client.helpers.domain.ServerStatus;
import infinispan.org.jboss.as.controller.client.helpers.domain.impl.DomainClientImpl;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.CallbackHandler;

public interface DomainClient
extends ModelControllerClient {
    public List<String> getHostControllerNames();

    public byte[] addDeploymentContent(InputStream var1);

    public DomainDeploymentManager getDeploymentManager();

    public Map<ServerIdentity, ServerStatus> getServerStatuses();

    public ServerStatus startServer(String var1, String var2);

    public ServerStatus stopServer(String var1, String var2, long var3, TimeUnit var5);

    public ServerStatus restartServer(String var1, String var2, long var3, TimeUnit var5);

    public static class Factory {
        public static DomainClient create(InetAddress address, int port) {
            return new DomainClientImpl(address, port);
        }

        public static DomainClient create(InetAddress address, int port, CallbackHandler handler) {
            return new DomainClientImpl(address, port, handler);
        }

        public static DomainClient create(String protocol, InetAddress address, int port) {
            return new DomainClientImpl(protocol, address, port);
        }

        public static DomainClient create(String protocol, InetAddress address, int port, CallbackHandler handler) {
            return new DomainClientImpl(protocol, address, port, handler);
        }

        public static DomainClient create(ModelControllerClient client) {
            return new DomainClientImpl(client);
        }
    }
}

