/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.common;

import infinispan.org.jboss.as.controller.OperationContext;
import infinispan.org.jboss.as.controller.OperationFailedException;
import infinispan.org.jboss.as.controller.OperationStepHandler;
import infinispan.org.jboss.as.controller.PathAddress;
import infinispan.org.jboss.as.controller.PathElement;
import infinispan.org.jboss.as.controller.SimpleOperationDefinition;
import infinispan.org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import infinispan.org.jboss.as.controller.access.Action;
import infinispan.org.jboss.as.controller.access.AuthorizationResult;
import infinispan.org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import infinispan.org.jboss.as.controller.descriptions.DescriptionProvider;
import infinispan.org.jboss.as.controller.descriptions.common.ControllerResolver;
import infinispan.org.jboss.as.controller.logging.ControllerLogger;
import infinispan.org.jboss.as.controller.operations.common.OrderedChildTypesAttachment;
import infinispan.org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import infinispan.org.jboss.as.controller.registry.Resource;
import infinispan.org.jboss.dmr.ModelNode;
import infinispan.org.jboss.dmr.ModelType;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;

public class GenericSubsystemDescribeHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final GenericSubsystemDescribeHandler INSTANCE = new GenericSubsystemDescribeHandler();
    public static final SimpleOperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("describe", ControllerResolver.getResolver("subsystem")).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.READ_WHOLE_CONFIG).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setPrivateEntry().build();
    public static final Set<Action.ActionEffect> DESCRIBE_EFFECTS = Collections.unmodifiableSet(EnumSet.of(Action.ActionEffect.ADDRESS, Action.ActionEffect.READ_CONFIG));
    public static final OperationContext.AttachmentKey<Boolean> SERVER_LAUNCH_KEY = OperationContext.AttachmentKey.create(Boolean.class);
    private final Comparator<PathElement> comparator;

    protected GenericSubsystemDescribeHandler() {
        this(null);
    }

    protected GenericSubsystemDescribeHandler(Comparator<PathElement> comparator) {
        this.comparator = comparator;
    }

    public static GenericSubsystemDescribeHandler create(Comparator<PathElement> comparator) {
        return new GenericSubsystemDescribeHandler(comparator);
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress pa = context.getCurrentAddress();
        AuthorizationResult authResult = context.authorize(operation, DESCRIBE_EFFECTS);
        if (authResult.getDecision() != AuthorizationResult.Decision.PERMIT) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.require("operation").asString(), pa, authResult.getExplanation());
        }
        ModelNode address = pa.size() > 0 ? new ModelNode().add(pa.getLastElement().getKey(), pa.getLastElement().getValue()) : new ModelNode().setEmptyList();
        Resource resource = context.readResource(PathAddress.EMPTY_ADDRESS);
        ModelNode result = context.getResult();
        this.describe(context.getAttachment(OrderedChildTypesAttachment.KEY), resource, address, result, context.getResourceRegistration());
    }

    protected void describe(OrderedChildTypesAttachment orderedChildTypesAttachment, Resource resource, ModelNode address, ModelNode result, ImmutableManagementResourceRegistration registration) {
        Set<PathElement> children;
        if (resource == null || registration.isRemote() || registration.isRuntimeOnly() || resource.isProxy() || resource.isRuntime() || registration.isAlias()) {
            return;
        }
        if (this.comparator == null) {
            children = registration.getChildAddresses(PathAddress.EMPTY_ADDRESS);
        } else {
            children = new TreeSet<PathElement>(this.comparator);
            children.addAll(registration.getChildAddresses(PathAddress.EMPTY_ADDRESS));
        }
        result.add(this.createAddOperation(orderedChildTypesAttachment, address, resource, children));
        for (PathElement element : children) {
            if (element.isMultiTarget()) {
                String childType = element.getKey();
                for (Resource.ResourceEntry entry : resource.getChildren(childType)) {
                    ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.pathAddress(PathElement.pathElement(childType, entry.getName())));
                    ModelNode childAddress = address.clone();
                    childAddress.add(childType, entry.getName());
                    this.describe(orderedChildTypesAttachment, entry, childAddress, result, childRegistration);
                }
                continue;
            }
            Resource child = resource.getChild(element);
            ImmutableManagementResourceRegistration childRegistration = registration.getSubModel(PathAddress.pathAddress(element));
            ModelNode childAddress = address.clone();
            childAddress.add(element.getKey(), element.getValue());
            this.describe(orderedChildTypesAttachment, child, childAddress, result, childRegistration);
        }
    }

    protected ModelNode createAddOperation(OrderedChildTypesAttachment orderedChildTypesAttachment, ModelNode address, Resource resource, Set<PathElement> children) {
        ModelNode addOp = this.createAddOperation(address, resource.getModel(), children);
        if (orderedChildTypesAttachment != null) {
            orderedChildTypesAttachment.addOrderedChildResourceTypes(PathAddress.pathAddress(address), resource);
        }
        return addOp;
    }

    protected ModelNode createAddOperation(ModelNode address, ModelNode subModel, Set<PathElement> children) {
        ModelNode operation = subModel.clone();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        if (children != null && !children.isEmpty()) {
            for (PathElement path : children) {
                if (!subModel.hasDefined(path.getKey())) continue;
                subModel.remove(path.getKey());
            }
        }
        return operation;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return DEFINITION.getDescriptionProvider().getModelDescription(locale);
    }
}

