/*
 * Decompiled with CFR 0.152.
 */
package infinispan.org.jboss.as.controller.operations.global;

import java.util.Locale;

public final class LocaleResolver {
    private static final String ENGLISH = new Locale("en").getLanguage();

    private LocaleResolver() {
    }

    static Locale resolveLocale(String unparsed) throws IllegalArgumentException {
        Locale locale = LocaleResolver.forLanguageTag(unparsed);
        if ("".equals(locale.getLanguage())) {
            throw new IllegalArgumentException(unparsed);
        }
        return LocaleResolver.replaceByRootLocaleIfLanguageIsEnglish(locale);
    }

    private static Locale forLanguageTag(String unparsed) {
        try {
            return Locale.forLanguageTag(unparsed);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException(unparsed);
        }
    }

    static Locale replaceByRootLocaleIfLanguageIsEnglish(Locale locale) {
        return locale.getLanguage().equals(ENGLISH) ? Locale.ROOT : locale;
    }
}

