/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.rhq.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerDiscovery
extends MBeanResourceDiscoveryComponent<JMXComponent> {
    private static final Log log = (Log)LogFactory.getLog(CacheManagerDiscovery.class, Log.class);
    protected static final String CACHE_MANAGER_OBJECTS = "*:type=CacheManager,*";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent> ctx) {
        Set<DiscoveredResourceDetails> discoveredResources;
        List manualCfgs;
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.tracef("Discover resources with context: %s", ctx);
        }
        if (!(manualCfgs = ctx.getPluginConfigurations()).isEmpty()) {
            discoveredResources = this.createDiscoveredResource(ctx, CACHE_MANAGER_OBJECTS);
            if (trace) {
                log.tracef("Manually discovered resources are %s", discoveredResources);
            }
        } else {
            discoveredResources = this.createDiscoveredResource(ctx, CACHE_MANAGER_OBJECTS);
            if (trace) {
                log.tracef("Automatically discovered resources are %s", discoveredResources);
            }
        }
        return discoveredResources;
    }

    private Set<DiscoveredResourceDetails> createDiscoveredResource(ResourceDiscoveryContext<JMXComponent> ctx, String objectName) {
        boolean trace = log.isTraceEnabled();
        JMXComponent parentComponent = (JMXComponent)ctx.getParentResourceComponent();
        EmsConnection conn = parentComponent.getEmsConnection();
        if (conn != null) {
            if (trace) {
                log.tracef("Connection to ems server established: %s", conn);
            }
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectName);
            List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
            if (trace) {
                log.tracef("Querying [%s] returned beans: %s", queryUtility.getTranslatedQuery(), beans);
            }
            HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
            for (EmsBean bean : beans) {
                String managerName = bean.getBeanName().getCanonicalName();
                String resourceName = bean.getAttribute("Name").getValue().toString();
                String version = bean.getAttribute("Version").getValue().toString();
                if (trace) {
                    log.tracef("Add resource with version '%s' and type %s", version, ctx.getResourceType());
                }
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(ctx.getResourceType(), resourceName, resourceName, version, "A cache manager within Infinispan", null, null);
                log.discoveredInfinispanInstance(resourceName, managerName);
                discoveredResources.add(detail);
            }
            return discoveredResources;
        }
        log.debug("Unable to establish connection");
        return null;
    }
}

