/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.rhq.RhqUtil;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerComponent
extends MBeanResourceComponent<MBeanResourceComponent<?>> {
    private static final Log log = LogFactory.getLog(CacheManagerComponent.class);
    protected ResourceContext<MBeanResourceComponent<?>> context;
    private String cacheManagerPattern;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getEmsConnection();
        try {
            conn.refresh();
            EmsBean bean = this.queryCacheManagerBean(conn);
            if (bean != null) {
                bean.refreshAttributes();
                if (trace) {
                    log.trace((Object)("Cache manager " + bean + " could be found and attributes where refreshed, so it's up."));
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace((Object)"Cache manager could not be found, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"There was an exception checking availability, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext<MBeanResourceComponent<?>> context) {
        this.context = context;
        this.cacheManagerPattern = "*:type=CacheManager,name=" + ObjectName.quote(context.getResourceKey()) + ",*";
    }

    public EmsConnection getEmsConnection() {
        return ((MBeanResourceComponent)this.context.getParentResourceComponent()).getEmsConnection();
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Get values for these metrics: " + metrics));
        }
        EmsConnection conn = this.getEmsConnection();
        if (trace) {
            log.trace((Object)("Connection to ems server established: " + conn));
        }
        EmsBean bean = this.queryCacheManagerBean(conn);
        bean.refreshAttributes();
        if (trace) {
            log.trace((Object)("Querying returned bean: " + bean));
        }
        for (MeasurementScheduleRequest req : metrics) {
            MeasurementDataNumeric res;
            DataType type = req.getDataType();
            if (type == DataType.MEASUREMENT) {
                EmsAttribute att = bean.getAttribute(req.getName());
                if (att == null) continue;
                res = RhqUtil.constructNumericMeasure(att.getTypeClass(), att.getValue(), req);
                report.addData(res);
                continue;
            }
            if (type != DataType.TRAIT) continue;
            String value = (String)bean.getAttribute(req.getName()).getValue();
            if (trace) {
                log.trace((Object)("Metric (" + req.getName() + ") is trait with value " + value));
            }
            res = new MeasurementDataTrait(req, value);
            report.addData((MeasurementDataTrait)res);
        }
    }

    private EmsBean queryCacheManagerBean(EmsConnection conn) {
        ObjectNameQueryUtility queryUtility;
        List beans;
        String pattern = this.cacheManagerPattern;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Pattern to query is " + pattern));
        }
        if ((beans = conn.queryBeans((queryUtility = new ObjectNameQueryUtility(pattern)).getTranslatedQuery())).size() > 1 && log.isWarnEnabled()) {
            log.warn((Object)String.format("More than one bean returned from applying %s pattern: %s", pattern, beans));
        }
        return (EmsBean)beans.get(0);
    }
}

