/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class InfinispanRhqTest {
    private static final String MY_CUSTOM_CACHE = "myCustomCache";

    public static void main(String[] args) throws Exception {
        GlobalConfiguration myGlobalConfig = new GlobalConfiguration();
        myGlobalConfig.setJmxDomain("org.infinispan");
        myGlobalConfig.setExposeGlobalJmxStatistics(true);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((GlobalConfiguration)myGlobalConfig)){

            public void call() {
                Configuration config = new Configuration();
                config.setExposeJmxStatistics(true);
                config.setEvictionMaxEntries(123);
                config.setExpirationMaxIdle(180000L);
                this.cm.defineConfiguration(InfinispanRhqTest.MY_CUSTOM_CACHE, config);
                Cache cache = this.cm.getCache(InfinispanRhqTest.MY_CUSTOM_CACHE);
                cache.put((Object)"myKey", (Object)"myValue");
                int i = 0;
                while (i < Integer.MAX_VALUE) {
                    try {
                        Thread.sleep(12000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    cache.put((Object)("key" + i), (Object)String.valueOf(i));
                    cache.get((Object)("key" + (int)(10000.0 * Math.random())));
                    if (++i % 10 != 0) continue;
                    System.out.print(".");
                    System.out.flush();
                }
            }
        });
    }
}

