/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.rhq.CacheDiscovery;
import org.infinispan.rhq.CacheManagerComponent;
import org.infinispan.rhq.RhqUtil;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheComponent
extends MBeanResourceComponent<CacheManagerComponent> {
    private static final Log log = LogFactory.getLog(CacheComponent.class);
    private ResourceContext<CacheManagerComponent> context;
    private String cacheManagerName;
    private String cacheName;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getConnection();
        try {
            conn.refresh();
            EmsBean bean = this.queryCacheBean();
            if (bean != null && bean.getAttribute("CacheStatus").getValue().equals("RUNNING")) {
                bean.refreshAttributes();
                if (trace) {
                    log.trace((Object)("Cache " + this.cacheName + " within " + this.cacheManagerName + " cache manager is running and attributes could be refreshed, so it's up."));
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace((Object)("Cache status for " + this.cacheName + " within " + this.cacheManagerName + " cache manager is anything other than running, so it's down."));
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"There was an exception checking availability, so cache status is down.", (Throwable)e);
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext<CacheManagerComponent> context) {
        this.context = context;
        this.cacheManagerName = ((CacheManagerComponent)context.getParentResourceComponent()).context.getResourceKey();
        this.cacheName = context.getResourceKey();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Start cache component for cache manager " + this.cacheManagerName + " with cache key " + this.cacheName));
        }
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Get values metrics");
        }
        for (MeasurementScheduleRequest req : metrics) {
            if (trace) {
                log.trace((Object)("Inspect metric " + req));
            }
            String metric = req.getName();
            try {
                EmsBean bean = this.queryComponentBean(metric);
                if (bean == null) continue;
                if (trace) {
                    log.trace((Object)("Retrieved mbean with name " + bean.getBeanName()));
                }
                bean.refreshAttributes();
                String attName = metric.substring(metric.indexOf(".") + 1);
                EmsAttribute att = bean.getAttribute(attName);
                if (att != null) {
                    Object o = att.getValue();
                    Class attrType = att.getTypeClass();
                    DataType type = req.getDataType();
                    if (type == DataType.MEASUREMENT) {
                        if (o != null) {
                            MeasurementDataNumeric res = RhqUtil.constructNumericMeasure(attrType, o, req);
                            if (res == null) continue;
                            report.addData(res);
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)("Metric (" + req.getName() + ") has null value, do not add to report"));
                        continue;
                    }
                    if (type != DataType.TRAIT) continue;
                    String value = (String)o;
                    if (trace) {
                        log.trace((Object)("Metric (" + req.getName() + ") is trait with value " + value));
                    }
                    MeasurementDataTrait res = new MeasurementDataTrait(req, value);
                    report.addData(res);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("Attribute " + attName + " not found"));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)("getValues failed for " + metric), (Throwable)e);
            }
        }
    }

    public OperationResult invokeOperation(String fullOpName, Configuration parameters) throws Exception {
        boolean trace = log.isTraceEnabled();
        EmsBean bean = this.queryComponentBean(fullOpName);
        String opName = fullOpName.substring(fullOpName.indexOf(".") + 1);
        EmsOperation ops = bean.getOperation(opName);
        Collection simples = parameters.getSimpleProperties().values();
        if (trace) {
            log.trace((Object)("Parameters, as simple properties, are " + simples));
        }
        Object[] realParams = new Object[simples.size()];
        int i = 0;
        for (PropertySimple property : simples) {
            realParams[i++] = property.getStringValue();
        }
        if (ops == null) {
            throw new Exception("Operation " + fullOpName + " can't be found");
        }
        Object result = ops.invoke(realParams);
        if (trace) {
            log.trace((Object)("Returning operation result containing " + result != null ? result.toString() : ""));
        }
        return new OperationResult(result != null ? result.toString() : "");
    }

    private EmsConnection getConnection() {
        return ((CacheManagerComponent)this.context.getParentResourceComponent()).getEmsConnection();
    }

    private String getSingleComponentPattern(String cacheManagerName, String cacheName, String componentName) {
        return this.namedCacheComponentPattern(cacheManagerName, cacheName, componentName) + ",*";
    }

    private String namedCacheComponentPattern(String cacheManagerName, String cacheName, String componentName) {
        return CacheDiscovery.cacheComponentPattern(cacheManagerName, componentName) + ",name=" + cacheName;
    }

    private EmsBean queryCacheBean() {
        return this.queryBean("Cache");
    }

    private EmsBean queryComponentBean(String name) {
        String componentName = name.substring(0, name.indexOf("."));
        return this.queryBean(componentName);
    }

    private EmsBean queryBean(String componentName) {
        EmsBean bean;
        ObjectNameQueryUtility queryUtility;
        List beans;
        EmsConnection conn = this.getConnection();
        String pattern = this.getSingleComponentPattern(this.cacheManagerName, this.cacheName, componentName);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Pattern to query is " + pattern));
        }
        if ((beans = conn.queryBeans((queryUtility = new ObjectNameQueryUtility(pattern)).getTranslatedQuery())).size() > 1 && log.isWarnEnabled()) {
            log.warn((Object)String.format("More than one bean returned from applying %s pattern: %s", pattern, beans));
        }
        if ((bean = (EmsBean)beans.get(0)) == null && log.isTraceEnabled()) {
            log.trace((Object)("No mbean found with name " + pattern));
        }
        return bean;
    }
}

