/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.rhq.RhqUtil;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.EmsBeanName;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.plugins.jmx.JMXServerComponent;
import org.rhq.plugins.jmx.MBeanResourceComponent;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerComponent
extends MBeanResourceComponent<JMXServerComponent<?>> {
    private static final Log log = LogFactory.getLog(CacheManagerComponent.class);
    protected ResourceContext<JMXServerComponent<?>> context;
    private String cacheManagerPattern;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getEmsConnection();
        try {
            conn.refresh();
            EmsBean bean = this.queryCacheManagerBean(conn);
            if (bean != null) {
                bean.refreshAttributes();
                if (trace) {
                    log.trace((Object)("Cache manager " + bean + " could be found and attributes where refreshed, so it's up."));
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace((Object)"Cache manager could not be found, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"There was an exception checking availability, so cache manager is down");
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext<JMXServerComponent<?>> context) {
        this.context = context;
        this.cacheManagerPattern = "*:type=CacheManager,component=CacheManager,name=" + ObjectName.quote(context.getResourceKey()) + ",*";
        super.start(context);
    }

    public EmsConnection getEmsConnection() {
        return ((JMXServerComponent)this.context.getParentResourceComponent()).getEmsConnection();
    }

    protected EmsBean loadBean() {
        return this.queryCacheManagerBean(this.getEmsConnection());
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        int paramSep = name.indexOf(124);
        if (paramSep > 0) {
            return super.invokeOperation(name.substring(0, paramSep), parameters);
        }
        return super.invokeOperation(name, parameters);
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Get values for these metrics: " + metrics));
        }
        EmsConnection conn = this.getEmsConnection();
        if (trace) {
            log.trace((Object)("Connection to ems server established: " + conn));
        }
        EmsBean bean = this.queryCacheManagerBean(conn);
        bean.refreshAttributes();
        if (trace) {
            log.trace((Object)("Querying returned bean: " + bean));
        }
        for (MeasurementScheduleRequest req : metrics) {
            MeasurementDataNumeric res;
            DataType type = req.getDataType();
            if (type == DataType.MEASUREMENT) {
                EmsAttribute att = bean.getAttribute(req.getName());
                if (att == null) continue;
                res = RhqUtil.constructNumericMeasure(att.getTypeClass(), att.getValue(), req);
                report.addData(res);
                continue;
            }
            if (type != DataType.TRAIT) continue;
            String value = (String)bean.getAttribute(req.getName()).getValue();
            if (trace) {
                log.trace((Object)("Metric (" + req.getName() + ") is trait with value " + value));
            }
            res = new MeasurementDataTrait(req, value);
            report.addData((MeasurementDataTrait)res);
        }
    }

    private EmsBean queryCacheManagerBean(EmsConnection conn) {
        String pattern = this.cacheManagerPattern;
        if (log.isTraceEnabled()) {
            log.trace((Object)("Pattern to query is " + pattern));
        }
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(pattern);
        List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
        for (EmsBean bean : beans) {
            if (CacheManagerComponent.isCacheManagerComponent(bean)) {
                return bean;
            }
            log.warn((Object)String.format("MBeanServer returned spurious object %s", bean.getBeanName().getCanonicalName()));
        }
        throw new IllegalStateException("MBeanServer unexpectedly did not return any CacheManager components");
    }

    protected static boolean isCacheManagerComponent(EmsBean bean) {
        EmsBeanName beanName = bean.getBeanName();
        return "CacheManager".equals(beanName.getKeyProperty("type")) && "CacheManager".equals(beanName.getKeyProperty("component"));
    }
}

