/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.rhq.CacheComponent;
import org.infinispan.rhq.CacheManagerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.util.ObjectNameQueryUtility;

public class CacheDiscovery
extends MBeanResourceDiscoveryComponent<CacheManagerComponent> {
    private static final Log log = LogFactory.getLog(CacheDiscovery.class);

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<CacheManagerComponent> ctx) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Discover resources with context");
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        EmsConnection conn = ((CacheManagerComponent)ctx.getParentResourceComponent()).getEmsConnection();
        if (trace) {
            log.trace((Object)"Connection to ems server established");
        }
        String pattern = CacheDiscovery.getAllCachesPattern(ctx.getParentResourceContext().getResourceKey());
        if (trace) {
            log.trace((Object)("Pattern to query is " + pattern));
        }
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(pattern);
        List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
        if (trace) {
            log.trace((Object)("Querying " + queryUtility.getTranslatedQuery() + " returned beans: " + beans));
        }
        for (EmsBean bean : beans) {
            if (CacheComponent.isCacheComponent(bean, "Cache")) {
                String name = bean.getAttribute("CacheName").getValue().toString();
                String mbeanCacheName = bean.getBeanName().getKeyProperty("name");
                if (trace) {
                    log.trace((Object)("Resource name is " + name + " and resource key " + mbeanCacheName));
                }
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(ctx.getResourceType(), mbeanCacheName, name, null, "One cache within Infinispan", ctx.getDefaultPluginConfiguration(), null);
                discoveredResources.add(detail);
                log.info((Object)("Discovered new ...  " + bean.getBeanName().getCanonicalName()));
                continue;
            }
            log.warn((Object)String.format("MBeanServer returned spurious object %s", bean.getBeanName().getCanonicalName()));
        }
        return discoveredResources;
    }

    protected static String getAllCachesPattern(String cacheManagerName) {
        return CacheDiscovery.cacheComponentPattern(cacheManagerName, "Cache") + ",*";
    }

    protected static String cacheComponentPattern(String cacheManagerName, String componentName) {
        return cacheManagerName.substring(0, cacheManagerName.indexOf(":")) + ":manager=" + cacheManagerName.substring(cacheManagerName.indexOf("=") + 1) + ",type=Cache,component=" + componentName;
    }
}

