/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;

public class InfinispanRhqTest {
    private static final String MY_CUSTOM_CACHE = "myCustomCache";

    public static void main(String[] args) throws Exception {
        String indexDirectory = TestingUtil.tmpDirectory(InfinispanRhqTest.class);
        try {
            InfinispanRhqTest.run(indexDirectory);
        }
        finally {
            TestingUtil.recursiveFileRemove((String)indexDirectory);
        }
    }

    private static void run(final String indexDirectory) {
        GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
        globalConfigurationBuilder.globalJmxStatistics().enable().jmxDomain("org.infinispan");
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)globalConfigurationBuilder, (ConfigurationBuilder)new ConfigurationBuilder())){

            public void call() {
                ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
                configurationBuilder.jmxStatistics().enable();
                configurationBuilder.eviction().maxEntries(123);
                configurationBuilder.expiration().maxIdle(180000L);
                configurationBuilder.indexing().index(Index.ALL).addProperty("default.directory_provider", "filesystem").addProperty("default.indexBase", indexDirectory).addProperty("lucene_version", "LUCENE_CURRENT");
                this.cm.defineConfiguration(InfinispanRhqTest.MY_CUSTOM_CACHE, configurationBuilder.build());
                Cache cache = this.cm.getCache(InfinispanRhqTest.MY_CUSTOM_CACHE);
                cache.put((Object)"myKey", (Object)"myValue");
                int i = 0;
                while (i < Integer.MAX_VALUE) {
                    try {
                        Thread.sleep(12000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    cache.put((Object)("key" + i), (Object)String.valueOf(i));
                    cache.get((Object)("key" + (int)(10000.0 * Math.random())));
                    if (++i % 10 != 0) continue;
                    System.out.print(".");
                    System.out.flush();
                }
            }
        });
    }
}

