/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rhq;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.management.ObjectName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.infinispan.rhq.CacheManagerComponent;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ManualAddFacet;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.JMXComponent;
import org.rhq.plugins.jmx.MBeanResourceDiscoveryComponent;
import org.rhq.plugins.jmx.util.ObjectNameQueryUtility;

public class CacheManagerDiscovery
extends MBeanResourceDiscoveryComponent<JMXComponent<?>>
implements ManualAddFacet<JMXComponent<?>> {
    private static final Log log = LogFactory.getLog(CacheManagerDiscovery.class);
    private static final boolean trace = log.isTraceEnabled();
    public static final String CACHE_MANAGER_JMX_GROUP = "type=CacheManager,component=CacheManager";
    protected static final String CACHE_MANAGER_OBJECTS = "*:type=CacheManager,component=CacheManager,*";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<JMXComponent<?>> ctx) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("Discover resources with context " + ctx));
        }
        Set<DiscoveredResourceDetails> discoveredResources = this.createDiscoveredResource(ctx, null, CACHE_MANAGER_OBJECTS);
        if (trace) {
            log.trace((Object)("Automatically discovered resources are " + discoveredResources));
        }
        return discoveredResources;
    }

    private Set<DiscoveredResourceDetails> createDiscoveredResource(ResourceDiscoveryContext<JMXComponent<?>> ctx, Configuration pluginConfiguration, String objectName) {
        boolean trace = log.isTraceEnabled();
        JMXComponent parentComponent = (JMXComponent)ctx.getParentResourceComponent();
        EmsConnection conn = parentComponent.getEmsConnection();
        if (conn != null) {
            if (trace) {
                log.trace((Object)("Connection to ems server established: " + conn));
            }
            ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(objectName);
            List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
            if (trace) {
                log.trace((Object)("Querying [" + queryUtility.getTranslatedQuery() + "] returned beans: " + beans));
            }
            HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
            for (EmsBean bean : beans) {
                if (CacheManagerComponent.isCacheManagerComponent(bean)) {
                    String managerName = bean.getBeanName().getCanonicalName();
                    String domain = managerName.substring(0, managerName.indexOf(":"));
                    String resourceName = bean.getAttribute("Name").getValue().toString();
                    String version = bean.getAttribute("Version").getValue().toString();
                    if (trace) {
                        log.trace((Object)("Add resource with version '" + version + "' and type " + ctx.getResourceType()));
                    }
                    DiscoveredResourceDetails detail = new DiscoveredResourceDetails(ctx.getResourceType(), domain + ":name=" + ObjectName.quote(resourceName), (beans.size() > 1 ? domain + ":" : "") + resourceName, version, "A cache manager within Infinispan", pluginConfiguration, null);
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Discovered Infinispan instance with key %s and name %s", resourceName, managerName));
                    }
                    discoveredResources.add(detail);
                    continue;
                }
                log.warn((Object)String.format("MBeanServer returned spurious object %s", bean.getBeanName().getCanonicalName()));
            }
            return discoveredResources;
        }
        log.debug((Object)"Unable to establish connection");
        return null;
    }

    public DiscoveredResourceDetails discoverResource(Configuration pluginConfiguration, ResourceDiscoveryContext<JMXComponent<?>> ctx) throws InvalidPluginConfigurationException {
        Set<DiscoveredResourceDetails> discoveredResources = this.createDiscoveredResource(ctx, pluginConfiguration, CACHE_MANAGER_OBJECTS);
        if (trace) {
            log.trace((Object)("Manually discovered resource: " + discoveredResources));
        }
        if (discoveredResources.size() > 0) {
            return discoveredResources.iterator().next();
        }
        throw new InvalidPluginConfigurationException("Expecting single resource, found " + discoveredResources.size());
    }
}

