/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx;

import java.util.Collections;
import javax.transaction.xa.Xid;
import org.infinispan.Cache;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.server.hotrod.HotRodMultiNodeTest;
import org.infinispan.server.hotrod.HotRodVersion;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestErrorResponse;
import org.infinispan.server.hotrod.test.TxResponse;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.test.TestingUtil;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.util.concurrent.IsolationLevel;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.tx.ServerConfigurationTest")
public class ServerConfigurationTest
extends HotRodMultiNodeTest {
    public void testNonTransactionalConfiguration() {
        String cacheName = "non_tx_cache";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        this.doWrongConfigurationTest("non_tx_cache", builder, "java.lang.IllegalStateException: ISPN006020: Cache 'non_tx_cache' is not transactional to execute a client transaction");
    }

    public void testWrongIsolationLevel() {
        String cacheName = "wrong_isolation_cache";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.locking().isolationLevel(IsolationLevel.READ_COMMITTED);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.doWrongConfigurationTest("wrong_isolation_cache", builder, "java.lang.IllegalStateException: ISPN006021: Cache 'wrong_isolation_cache' must have REPEATABLE_READ isolation level");
    }

    public void testSynchronizationMode() {
        String cacheName = "sync_cache";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().useSynchronization(true);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.doCorrectConfigurationTest("sync_cache", builder);
    }

    public void testXa() {
        String cacheName = "xa_cache";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().useSynchronization(false);
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.doCorrectConfigurationTest("xa_cache", builder);
    }

    public void testFullXa() {
        String cacheName = "full_xa_cache";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().useSynchronization(false);
        builder.transaction().recovery().enable();
        builder.transaction().lockingMode(LockingMode.PESSIMISTIC);
        this.doCorrectConfigurationTest("full_xa_cache", builder);
    }

    public void testOptimisticConfiguration() {
        String cacheName = "opt-cache";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().lockingMode(LockingMode.OPTIMISTIC);
        this.doWrongConfigurationTest("opt-cache", builder, "java.lang.IllegalStateException: Cache 'opt-cache' cannot use Optimistic neither Total Order transactions.");
    }

    public void testTotalOrderConfiguration() {
        String cacheName = "total-order-cache";
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        builder.transaction().transactionProtocol(TransactionProtocol.TOTAL_ORDER);
        builder.clustering().cacheMode(CacheMode.REPL_SYNC);
        this.doWrongConfigurationTest("total-order-cache", builder, "java.lang.IllegalStateException: Cache 'total-order-cache' cannot use Optimistic neither Total Order transactions.");
    }

    @Override
    protected String cacheName() {
        return "default";
    }

    @Override
    protected ConfigurationBuilder createCacheConfig() {
        return new ConfigurationBuilder();
    }

    @Override
    protected byte protocolVersion() {
        return HotRodVersion.HOTROD_27.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWrongConfigurationTest(String cacheName, ConfigurationBuilder builder, String errorMsg) {
        this.cacheManagers.forEach(cm -> cm.defineConfiguration(cacheName, builder.build()));
        this.waitForClusterToForm(cacheName);
        HotRodClient client = this.createClient(cacheName);
        XidImpl xid = XidImpl.create((int)-1, (byte[])new byte[]{2}, (byte[])new byte[]{3});
        try {
            TestErrorResponse response = (TestErrorResponse)client.prepareTx((Xid)xid, false, Collections.emptyList());
            AssertJUnit.assertEquals((String)errorMsg, (String)response.msg);
            TxResponse response2 = (TxResponse)client.commitTx((Xid)xid);
            AssertJUnit.assertEquals((int)-4, (int)response2.xaCode);
            response2 = (TxResponse)client.rollbackTx((Xid)xid);
            AssertJUnit.assertEquals((int)-4, (int)response2.xaCode);
            this.assertServerTransactionTableEmpty(cacheName);
        }
        finally {
            HotRodTestingUtil.killClient(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCorrectConfigurationTest(String cacheName, ConfigurationBuilder builder) {
        this.cacheManagers.forEach(cm -> cm.defineConfiguration(cacheName, builder.build()));
        this.waitForClusterToForm(cacheName);
        HotRodClient client = this.createClient(cacheName);
        XidImpl xid = XidImpl.create((int)-1, (byte[])new byte[]{2}, (byte[])new byte[]{3});
        try {
            TxResponse response = (TxResponse)client.prepareTx((Xid)xid, false, Collections.emptyList());
            AssertJUnit.assertEquals((int)3, (int)response.xaCode);
            response = (TxResponse)client.commitTx((Xid)xid);
            AssertJUnit.assertEquals((int)-4, (int)response.xaCode);
            response = (TxResponse)client.rollbackTx((Xid)xid);
            AssertJUnit.assertEquals((int)-4, (int)response.xaCode);
            this.assertServerTransactionTableEmpty(cacheName);
        }
        finally {
            HotRodTestingUtil.killClient(client);
        }
    }

    private void assertServerTransactionTableEmpty(String cacheName) {
        for (Cache cache : this.caches(cacheName)) {
            if (!cache.getCacheConfiguration().transaction().transactionMode().isTransactional()) continue;
            PerCacheTxTable perCacheTxTable = (PerCacheTxTable)TestingUtil.extractComponent((Cache)cache, PerCacheTxTable.class);
            AssertJUnit.assertTrue((boolean)perCacheTxTable.isEmpty());
        }
    }

    private HotRodClient createClient(String cacheName) {
        return new HotRodClient("127.0.0.1", this.servers().get(0).getPort(), cacheName, 60, this.protocolVersion());
    }
}

