/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.EnumSet;
import java.util.Map;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.annotations.InfinispanModule;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.lifecycle.ModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.server.hotrod.KeyValueVersionConverter;
import org.infinispan.server.hotrod.ServerAddress;
import org.infinispan.server.hotrod.event.KeyValueWithPreviousEventConverterExternalizer;
import org.infinispan.server.hotrod.iteration.IterationFilter;
import org.infinispan.server.hotrod.tx.ServerTransactionOriginatorChecker;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.ClientAddress;
import org.infinispan.server.hotrod.tx.table.GlobalTxTable;
import org.infinispan.server.hotrod.tx.table.PerCacheTxTable;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.ConditionalMarkAsRollbackFunction;
import org.infinispan.server.hotrod.tx.table.functions.CreateStateFunction;
import org.infinispan.server.hotrod.tx.table.functions.PreparingDecisionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetCompletedTransactionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetDecisionFunction;
import org.infinispan.server.hotrod.tx.table.functions.SetPreparedFunction;
import org.infinispan.server.hotrod.tx.table.functions.XidPredicate;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.impl.TransactionOriginatorChecker;

@InfinispanModule(name="server-hotrod", requiredModules={"core"})
public class LifecycleCallbacks
implements ModuleLifecycle {
    private static final String GLOBAL_TX_TABLE_CACHE_NAME = "org.infinispan.CLIENT_SERVER_TX_TABLE";
    @GuardedBy(value="this")
    private boolean registered = false;
    private GlobalComponentRegistry globalComponentRegistry;
    private GlobalConfiguration globalCfg;

    public void cacheManagerStarting(GlobalComponentRegistry gcr, GlobalConfiguration globalCfg) {
        this.globalComponentRegistry = gcr;
        this.globalCfg = globalCfg;
        Map externalizers = globalCfg.serialization().advancedExternalizers();
        externalizers.put(1104, new ServerAddress.Externalizer());
        externalizers.put(1108, new KeyValueVersionConverter.Externalizer());
        externalizers.put(1110, new KeyValueWithPreviousEventConverterExternalizer());
        externalizers.put(1111, new IterationFilter.IterationFilterExternalizer());
        externalizers.put(1113, TxState.EXTERNALIZER);
        externalizers.put(1114, CacheXid.EXTERNALIZER);
        externalizers.put(1115, ClientAddress.EXTERNALIZER);
        externalizers.put(1116, CreateStateFunction.EXTERNALIZER);
        externalizers.put(1117, PreparingDecisionFunction.EXTERNALIZER);
        externalizers.put(1118, SetCompletedTransactionFunction.EXTERNALIZER);
        externalizers.put(1119, SetDecisionFunction.EXTERNALIZER);
        externalizers.put(1120, SetPreparedFunction.EXTERNALIZER);
        externalizers.put(1121, XidPredicate.EXTERNALIZER);
        externalizers.put(1122, ConditionalMarkAsRollbackFunction.EXTERNALIZER);
        this.registerGlobalTxTable();
    }

    public void cacheManagerStarted(GlobalComponentRegistry gcr) {
    }

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        this.registerServerTransactionTable(cr, cacheName);
    }

    private void registerServerTransactionTable(ComponentRegistry componentRegistry, String cacheName) {
        if (GLOBAL_TX_TABLE_CACHE_NAME.equals(cacheName) || !((Configuration)componentRegistry.getComponent(Configuration.class)).transaction().transactionMode().isTransactional()) {
            return;
        }
        EmbeddedCacheManager cacheManager = (EmbeddedCacheManager)this.globalComponentRegistry.getComponent(EmbeddedCacheManager.class);
        this.createGlobalTxTable(cacheManager);
        BasicComponentRegistry basicComponentRegistry = (BasicComponentRegistry)componentRegistry.getComponent(BasicComponentRegistry.class);
        basicComponentRegistry.replaceComponent(PerCacheTxTable.class.getName(), (Object)new PerCacheTxTable(cacheManager.getAddress()), true);
        basicComponentRegistry.replaceComponent(TransactionOriginatorChecker.class.getName(), (Object)new ServerTransactionOriginatorChecker(), true);
        componentRegistry.rewire();
    }

    private void registerGlobalTxTable() {
        InternalCacheRegistry registry = (InternalCacheRegistry)this.globalComponentRegistry.getComponent(InternalCacheRegistry.class);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(this.globalCfg.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL);
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        registry.registerInternalCache(GLOBAL_TX_TABLE_CACHE_NAME, builder.build(), EnumSet.noneOf(InternalCacheRegistry.Flag.class));
    }

    private synchronized void createGlobalTxTable(EmbeddedCacheManager cacheManager) {
        if (!this.registered) {
            Cache cache = cacheManager.getCache(GLOBAL_TX_TABLE_CACHE_NAME);
            GlobalTxTable txTable = new GlobalTxTable((Cache<CacheXid, TxState>)cache, this.globalComponentRegistry);
            this.globalComponentRegistry.registerComponent((Object)txTable, GlobalTxTable.class);
            this.registered = true;
        }
    }
}

