/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.core.security.ServerAuthenticationProvider;
import org.infinispan.server.hotrod.configuration.SaslConfiguration;

public class AuthenticationConfiguration
implements ConfigurationInfo {
    static final AttributeDefinition<String> SECURITY_REALM = AttributeDefinition.builder((String)"security-realm", null, String.class).build();
    private final AttributeSet attributes;
    private final boolean enabled;
    private final SaslConfiguration saslConfiguration;
    private final ServerAuthenticationProvider serverAuthenticationProvider;
    private final Subject serverSubject;
    private static final ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition("authentication");

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(AuthenticationConfiguration.class, new AttributeDefinition[]{SECURITY_REALM});
    }

    AuthenticationConfiguration(AttributeSet attributes, SaslConfiguration saslConfiguration, boolean enabled, ServerAuthenticationProvider serverAuthenticationProvider, Subject serverSubject) {
        this.attributes = attributes.checkProtection();
        this.saslConfiguration = saslConfiguration;
        this.enabled = enabled;
        this.serverAuthenticationProvider = serverAuthenticationProvider;
        this.serverSubject = serverSubject;
    }

    public AttributeSet attributes() {
        return this.attributes;
    }

    public List<ConfigurationInfo> subElements() {
        return Collections.singletonList(this.saslConfiguration);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Set<String> allowedMechs() {
        return this.saslConfiguration.mechanisms();
    }

    public ServerAuthenticationProvider serverAuthenticationProvider() {
        return this.serverAuthenticationProvider;
    }

    public Map<String, String> mechProperties() {
        return this.saslConfiguration.mechProperties();
    }

    public String serverName() {
        return this.saslConfiguration.serverName();
    }

    public Subject serverSubject() {
        return this.serverSubject;
    }

    public SaslConfiguration sasl() {
        return this.saslConfiguration;
    }

    public String toString() {
        return "AuthenticationConfiguration{attributes=" + this.attributes + ", enabled=" + this.enabled + ", saslConfiguration=" + this.saslConfiguration + ", serverAuthenticationProvider=" + this.serverAuthenticationProvider + ", serverSubject=" + this.serverSubject + '}';
    }
}

