/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import io.netty.channel.Channel;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.security.auth.Subject;
import org.infinispan.commons.marshall.WrappedByteArray;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.server.hotrod.BaseRequestProcessor;
import org.infinispan.server.hotrod.HotRodHeader;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.util.logging.LogFactory;

class MultimapRequestProcessor
extends BaseRequestProcessor {
    private static final Log log = (Log)LogFactory.getLog(MultimapRequestProcessor.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();

    MultimapRequestProcessor(Channel channel, Executor executor, HotRodServer server) {
        super(channel, executor, server);
    }

    void get(HotRodHeader header, Subject subject, byte[] key) {
        if (trace) {
            log.trace("Call get");
        }
        WrappedByteArray keyWrappped = new WrappedByteArray(key);
        this.server.multimap(header, subject).get((Object)keyWrappped).whenComplete((result, throwable) -> this.handleGet(header, (Collection<WrappedByteArray>)result, (Throwable)throwable));
    }

    private void handleGet(HotRodHeader header, Collection<WrappedByteArray> result, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            try {
                OperationStatus status = OperationStatus.Success;
                if (result.isEmpty()) {
                    status = OperationStatus.KeyDoesNotExist;
                }
                this.writeResponse(header, header.encoder().multimapCollectionResponse(header, this.server, this.channel, status, this.mapToCollectionOfByteArrays(result)));
            }
            catch (Throwable t2) {
                this.writeException(header, t2);
            }
        }
    }

    void getWithMetadata(HotRodHeader header, Subject subject, byte[] key) {
        if (trace) {
            log.trace("Call getWithMetadata");
        }
        WrappedByteArray keyWrappped = new WrappedByteArray(key);
        this.server.multimap(header, subject).getEntry((Object)keyWrappped).whenComplete((entry, throwable) -> this.handleGetWithMetadata(header, (Optional<CacheEntry<WrappedByteArray, Collection<WrappedByteArray>>>)entry, (Throwable)throwable));
    }

    private void handleGetWithMetadata(HotRodHeader header, Optional<CacheEntry<WrappedByteArray, Collection<WrappedByteArray>>> entry, Throwable throwable) {
        if (throwable != null) {
            this.writeException(header, throwable);
        } else {
            try {
                OperationStatus status = OperationStatus.KeyDoesNotExist;
                CacheEntry<WrappedByteArray, Collection<WrappedByteArray>> ce = null;
                Set<byte[]> result = null;
                if (entry.isPresent()) {
                    status = OperationStatus.Success;
                    ce = entry.get();
                    result = this.mapToCollectionOfByteArrays((Collection)ce.getValue());
                }
                this.writeResponse(header, header.encoder().multimapEntryResponse(header, this.server, this.channel, status, ce, result));
            }
            catch (Throwable t2) {
                this.writeException(header, t2);
            }
        }
    }

    private Set<byte[]> mapToCollectionOfByteArrays(Collection<WrappedByteArray> result) {
        return result.stream().map(WrappedByteArray::getBytes).collect(Collectors.toSet());
    }

    void put(HotRodHeader header, Subject subject, byte[] key, byte[] value) {
        if (trace) {
            log.trace("Call put");
        }
        WrappedByteArray keyWrappped = new WrappedByteArray(key);
        WrappedByteArray valueWrapped = new WrappedByteArray(value);
        this.server.multimap(header, subject).put((Object)keyWrappped, (Object)valueWrapped).whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.writeException(header, (Throwable)throwable);
            } else {
                this.writeResponse(header, header.encoder().emptyResponse(header, this.server, this.channel, OperationStatus.Success));
            }
        });
    }

    void removeKey(HotRodHeader header, Subject subject, byte[] key) {
        if (trace) {
            log.trace("Call removeKey");
        }
        WrappedByteArray keyWrappped = new WrappedByteArray(key);
        this.server.multimap(header, subject).remove((Object)keyWrappped).whenComplete(this.handleBoolean(header));
    }

    void removeEntry(HotRodHeader header, Subject subject, byte[] key, byte[] value) {
        log.trace("Call removeEntry");
        WrappedByteArray keyWrappped = new WrappedByteArray(key);
        WrappedByteArray valueWrapped = new WrappedByteArray(value);
        this.server.multimap(header, subject).remove((Object)keyWrappped, (Object)valueWrapped).whenComplete(this.handleBoolean(header));
    }

    void size(HotRodHeader header, Subject subject) {
        log.trace("Call size");
        this.server.multimap(header, subject).size().whenComplete((result, throwable) -> {
            if (throwable != null) {
                this.writeException(header, (Throwable)throwable);
            } else {
                this.writeResponse(header, header.encoder().unsignedLongResponse(header, this.server, this.channel, (long)result));
            }
        });
    }

    void containsEntry(HotRodHeader header, Subject subject, byte[] key, byte[] value) {
        log.trace("Call containsEntry");
        WrappedByteArray keyWrappped = new WrappedByteArray(key);
        WrappedByteArray valueWrapped = new WrappedByteArray(value);
        this.server.multimap(header, subject).containsEntry((Object)keyWrappped, (Object)valueWrapped).whenComplete(this.handleBoolean(header));
    }

    void containsKey(HotRodHeader header, Subject subject, byte[] key) {
        log.trace("Call containsKey");
        WrappedByteArray keyWrappped = new WrappedByteArray(key);
        this.server.multimap(header, subject).containsKey((Object)keyWrappped).whenComplete(this.handleBoolean(header));
    }

    void containsValue(HotRodHeader header, Subject subject, byte[] value) {
        log.trace("Call containsValue");
        WrappedByteArray valueWrapped = new WrappedByteArray(value);
        this.server.multimap(header, subject).containsValue((Object)valueWrapped).whenComplete(this.handleBoolean(header));
    }

    private BiConsumer<Boolean, Throwable> handleBoolean(HotRodHeader header) {
        return (result, throwable) -> {
            if (throwable != null) {
                this.writeException(header, (Throwable)throwable);
            } else {
                this.writeResponse(header, header.encoder().booleanResponse(header, this.server, this.channel, (boolean)result));
            }
        };
    }
}

