/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.configuration;

import java.util.Arrays;
import java.util.List;
import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.configuration.ConfigurationInfo;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.elements.DefaultElementDefinition;
import org.infinispan.commons.configuration.elements.ElementDefinition;
import org.infinispan.server.core.configuration.EncryptionConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.SslConfiguration;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.AuthenticationConfiguration;
import org.infinispan.server.hotrod.configuration.HotRodServerConfigurationBuilder;
import org.infinispan.server.hotrod.configuration.TopologyCacheConfiguration;

@BuiltBy(value=HotRodServerConfigurationBuilder.class)
@ConfigurationFor(value=HotRodServer.class)
public class HotRodServerConfiguration
extends ProtocolServerConfiguration {
    public static final String TOPOLOGY_CACHE_NAME_PREFIX = "___hotRodTopologyCache";
    public static final AttributeDefinition<String> PROXY_HOST = AttributeDefinition.builder((String)"externalHost", null, String.class).immutable().build();
    public static final AttributeDefinition<Integer> PROXY_PORT = AttributeDefinition.builder((String)"externalPort", (Object)-1).immutable().build();
    public static final AttributeDefinition<Integer> WORKER_THREADS = AttributeDefinition.builder((String)"worker-threads", (Object)160).immutable().build();
    private final Attribute<String> proxyHost;
    private final Attribute<Integer> proxyPort;
    private final TopologyCacheConfiguration topologyCache;
    private final AuthenticationConfiguration authentication;
    private final EncryptionConfiguration encryption;
    public static ElementDefinition ELEMENT_DEFINITION = new DefaultElementDefinition("hotrod-connector");

    public static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(HotRodServerConfiguration.class, ProtocolServerConfiguration.attributeDefinitionSet(), new AttributeDefinition[]{WORKER_THREADS, PROXY_HOST, PROXY_PORT});
    }

    public List<ConfigurationInfo> subElements() {
        return Arrays.asList(this.topologyCache, this.authentication, this.encryption);
    }

    HotRodServerConfiguration(AttributeSet attributes, TopologyCacheConfiguration topologyCache, SslConfiguration ssl, AuthenticationConfiguration authentication, EncryptionConfiguration encryption) {
        super(attributes, ssl);
        this.topologyCache = topologyCache;
        this.authentication = authentication;
        this.encryption = encryption;
        this.proxyHost = attributes.attribute(PROXY_HOST);
        this.proxyPort = attributes.attribute(PROXY_PORT);
    }

    public ElementDefinition getElementDefinition() {
        return ELEMENT_DEFINITION;
    }

    public String proxyHost() {
        return (String)this.proxyHost.get();
    }

    public String publicHost() {
        return this.proxyHost.isNull() ? this.host() : (String)this.proxyHost.get();
    }

    public int proxyPort() {
        return (Integer)this.proxyPort.get();
    }

    public int publicPort() {
        return this.proxyPort.isModified() ? ((Integer)this.proxyPort.get()).intValue() : this.port();
    }

    public String topologyCacheName() {
        String name = this.name();
        return TOPOLOGY_CACHE_NAME_PREFIX + (name.length() > 0 ? "_" + name : name);
    }

    public long topologyLockTimeout() {
        return this.topologyCache.lockTimeout();
    }

    public long topologyReplTimeout() {
        return this.topologyCache.replicationTimeout();
    }

    public boolean topologyAwaitInitialTransfer() {
        return this.topologyCache.awaitInitialTransfer();
    }

    public boolean topologyStateTransfer() {
        return !this.topologyCache.lazyRetrieval();
    }

    public AuthenticationConfiguration authentication() {
        return this.authentication;
    }

    public TopologyCacheConfiguration topologyCache() {
        return this.topologyCache;
    }

    public EncryptionConfiguration encryption() {
        return this.encryption;
    }

    public String toString() {
        return "HotRodServerConfiguration{proxyHost=" + this.proxyHost + ", proxyPort=" + this.proxyPort + ", topologyCache=" + this.topologyCache + ", authentication=" + this.authentication + ", encryption=" + this.encryption + '}';
    }
}

