/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.tx.XidImpl;
import org.infinispan.remoting.transport.Address;
import org.infinispan.server.hotrod.logging.Log;
import org.infinispan.server.hotrod.tx.table.ClientAddress;
import org.infinispan.transaction.tm.EmbeddedTransaction;

public class PerCacheTxTable {
    private static final Log log = (Log)LogFactory.getLog(PerCacheTxTable.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final Map<XidImpl, EmbeddedTransaction> localTxTable = new ConcurrentHashMap<XidImpl, EmbeddedTransaction>();
    private final ClientAddress clientAddress;

    public PerCacheTxTable(Address address) {
        this.clientAddress = new ClientAddress(address);
    }

    public ClientAddress getClientAddress() {
        return this.clientAddress;
    }

    public EmbeddedTransaction getLocalTx(XidImpl xid) {
        return this.localTxTable.get(xid);
    }

    public void removeLocalTx(XidImpl xid) {
        EmbeddedTransaction tx = this.localTxTable.remove(xid);
        if (trace) {
            log.tracef("[%s] Removed tx=%s", xid, tx);
        }
    }

    public void createLocalTx(XidImpl xid, EmbeddedTransaction tx) {
        this.localTxTable.put(xid, tx);
        if (trace) {
            log.tracef("[%s] New tx=%s", xid, tx);
        }
    }

    public boolean isEmpty() {
        if (trace) {
            log.tracef("Active Transactions: %s", this.localTxTable.keySet());
        }
        return this.localTxTable.isEmpty();
    }
}

