/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.logging;

import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.dataconversion.EncodingException;
import org.infinispan.counter.exception.CounterException;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.server.hotrod.MissingFactoryException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Once;

@MessageLogger(projectCode="ISPN")
public interface Log
extends BasicLogger {
    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Exception reported", id=5003)
    public void exceptionReported(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No members for new topology after applying consistent hash %s filtering into base topology %s", id=5019)
    public void noMembersInHashTopology(ConsistentHash var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="No members in new topology", id=5020)
    public void noMembersInTopology();

    @LogMessage(level=Logger.Level.ERROR)
    @Message(value="Error detecting crashed member", id=6002)
    public void errorDetectingCrashedMember(@Cause Throwable var1);

    @Message(value="Cannot enable authentication without specifying a ServerAuthenticationProvider", id=6005)
    public CacheConfigurationException serverAuthenticationProvider();

    @Message(value="The specified allowedMechs [%s] contains mechs which are unsupported by the underlying factories [%s]", id=6006)
    public CacheConfigurationException invalidAllowedMechs(Set<String> var1, Set<String> var2);

    @Message(value="The requested operation is invalid", id=6007)
    public UnsupportedOperationException invalidOperation();

    @Message(value="A serverName must be specified when enabling authentication", id=6008)
    public CacheConfigurationException missingServerName();

    @Message(value="Event not handled by current Hot Rod event implementation: '%s'", id=6009)
    public IllegalStateException unexpectedEvent(Event var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Conditional operation '%s' should be used with transactional caches, otherwise data inconsistency issues could arise under failure situations", id=6010)
    @Once
    public void warnConditionalOperationNonTransactional(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Operation '%s' forced to return previous value should be used on transactional caches, otherwise data inconsistency issues could arise under failure situations", id=6011)
    @Once
    public void warnForceReturnPreviousNonTransactional(String var1);

    @Message(value="Listener %s factory '%s' not found in server", id=6013)
    public MissingFactoryException missingCacheEventFactory(String var1, String var2);

    @Message(value="Trying to add a filter and converter factory with name '%s' but it does not extend CacheEventFilterConverterFactory", id=6014)
    public IllegalStateException illegalFilterConverterEventFactory(String var1);

    @Message(value="Factory '%s' not found in server", id=6016)
    public IllegalStateException missingKeyValueFilterConverterFactory(String var1);

    @Message(value="Unauthorized '%s' operation", id=6017)
    public SecurityException unauthorizedOperation(String var1);

    @Message(value="EXTERNAL SASL mechanism not allowed without SSL client certificate", id=6018)
    public SecurityException externalMechNotAllowedWithoutSSLClientCert();

    @Message(value="A host or proxyHost address has not been specified", id=6019)
    public CacheConfigurationException missingHostAddress();

    @Message(value="Cache '%s' is not transactional to execute a client transaction", id=6020)
    public IllegalStateException expectedTransactionalCache(String var1);

    @Message(value="Cache '%s' must have REPEATABLE_READ isolation level", id=6021)
    public IllegalStateException unexpectedIsolationLevel(String var1);

    @Message(value="Expects a STRONG counter for '%s'", id=28023)
    public CounterException invalidWeakCounter(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Not wrapping custom marshaller with media type '%s' since the format is already supported by the server", id=28024)
    @Once
    public void skippingMarshallerWrapping(String var1);

    @Message(value="Error serializing script response '%s'", id=28025)
    public EncodingException errorSerializingResponse(Object var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(value="Removed unclosed iterator '%s'", id=28026)
    public void removedUnclosedIterator(String var1);

    @Message(value="Invalid credentials", id=28027)
    public SecurityException authenticationException(@Cause Throwable var1);
}

