/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.server.hotrod.ServerAddress;

public class MultiHomedServerAddress
implements ServerAddress {
    private final int port;
    private final List<InetAddressWithNetMask> addresses;
    static byte[] netMaskByPrefix = new byte[]{-128, -64, -32, -16, -8, -4, -2};

    public MultiHomedServerAddress(int port) {
        this.port = port;
        this.addresses = new ArrayList<InetAddressWithNetMask>();
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                for (InterfaceAddress address : intf.getInterfaceAddresses()) {
                    this.addresses.add(new InetAddressWithNetMask(address));
                }
            }
        }
        catch (IOException e) {
            throw new CacheConfigurationException((Exception)e);
        }
    }

    private MultiHomedServerAddress(List<InetAddressWithNetMask> addresses, int port) {
        this.addresses = addresses;
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiHomedServerAddress that = (MultiHomedServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.addresses.equals(that.addresses);
    }

    public int hashCode() {
        int result = this.addresses.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String toString() {
        return "MultiHomedServerAddress{port=" + this.port + ", addresses=" + this.addresses + '}';
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHost(InetAddress localAddress) {
        for (InetAddressWithNetMask address : this.addresses) {
            if (!MultiHomedServerAddress.inetAddressMatchesInterfaceAddress(localAddress.getAddress(), address.address.getAddress(), address.prefixLength)) continue;
            return address.address.getHostAddress();
        }
        throw new IllegalArgumentException("No interface address matching " + localAddress);
    }

    public static boolean inetAddressMatchesInterfaceAddress(byte[] inetAddress, byte[] interfaceAddress, int prefixLength) {
        for (int i = 0; i < inetAddress.length; ++i) {
            byte a = inetAddress[i];
            byte b = interfaceAddress[i];
            if (prefixLength >= 8) {
                if (a != b) {
                    return false;
                }
                prefixLength -= 8;
                continue;
            }
            if (prefixLength <= 0) continue;
            if ((a & netMaskByPrefix[prefixLength - 1]) != (b & netMaskByPrefix[prefixLength - 1])) {
                return false;
            }
            prefixLength = 0;
        }
        return true;
    }

    static class Externalizer
    extends AbstractExternalizer<MultiHomedServerAddress> {
        Externalizer() {
        }

        public Set<Class<? extends MultiHomedServerAddress>> getTypeClasses() {
            return Collections.singleton(MultiHomedServerAddress.class);
        }

        public void writeObject(ObjectOutput output, MultiHomedServerAddress object) throws IOException {
            output.writeInt(object.addresses.size());
            for (InetAddressWithNetMask address : object.addresses) {
                output.writeObject(address.address.getHostAddress());
                output.writeShort(address.prefixLength);
            }
            output.writeShort(object.port);
        }

        public MultiHomedServerAddress readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            int size = input.readInt();
            ArrayList<InetAddressWithNetMask> addresses = new ArrayList<InetAddressWithNetMask>(size);
            for (int i = 0; i < size; ++i) {
                String address = (String)input.readObject();
                short prefixLength = input.readShort();
                addresses.add(new InetAddressWithNetMask(InetAddress.getByName(address), prefixLength));
            }
            int port = input.readUnsignedShort();
            return new MultiHomedServerAddress(addresses, port);
        }
    }

    public static class InetAddressWithNetMask {
        final InetAddress address;
        final short prefixLength;

        public InetAddressWithNetMask(InterfaceAddress address) {
            this.address = address.getAddress();
            this.prefixLength = address.getNetworkPrefixLength();
        }

        public InetAddressWithNetMask(InetAddress address, short prefixLength) {
            this.address = address;
            this.prefixLength = prefixLength;
        }

        public String toString() {
            return this.address + "/" + this.prefixLength;
        }
    }
}

