/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.time.ControlledTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.iteration.IterationManager;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.CleanupAfterMethod;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(testName="server.hotrod.HotRodIteratorReapTest", groups={"functional"})
@CleanupAfterMethod
public class HotRodIteratorReapTest
extends HotRodSingleNodeTest {
    ControlledTimeService timeService = new ControlledTimeService();

    @Override
    protected EmbeddedCacheManager createCacheManager() {
        EmbeddedCacheManager cm = super.createCacheManager();
        TestingUtil.replaceComponent((CacheContainer)cm, TimeService.class, (Object)this.timeService, (boolean)true);
        return cm;
    }

    public void testIterationStateReaperOnClosedConnections() throws InterruptedException {
        IterationManager iterationManager = this.server().getIterationManager();
        for (int i = 0; i < 10; ++i) {
            this.hotRodClient.iteratorStart(null, null, null, 10, false);
        }
        AssertJUnit.assertEquals((int)10, (int)iterationManager.activeIterations());
        this.hotRodClient.stop().await();
        this.eventuallyEquals(0, () -> ((IterationManager)iterationManager).activeIterations());
    }

    public void testIterationStateReaperOnTimeout() {
        IterationManager iterationManager = this.server().getIterationManager();
        for (int i = 0; i < 10; ++i) {
            this.hotRodClient.iteratorStart(null, null, null, 10, false);
        }
        AssertJUnit.assertEquals((int)10, (int)iterationManager.activeIterations());
        this.timeService.advance(TimeUnit.MINUTES.toMillis(5L));
        AssertJUnit.assertEquals((int)0, (int)iterationManager.activeIterations());
    }
}

