/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.commons.jmx.TestMBeanServerLookup;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.HotRodStatsTest")
public class HotRodStatsTest
extends HotRodSingleNodeTest {
    private final MBeanServerLookup mBeanServerLookup = TestMBeanServerLookup.create();

    @Override
    public EmbeddedCacheManager createTestCacheManager() {
        ConfigurationBuilder cfg = HotRodTestingUtil.hotRodCacheConfiguration();
        cfg.statistics().enable();
        GlobalConfigurationBuilder globalCfg = GlobalConfigurationBuilder.defaultClusteredBuilder();
        globalCfg.cacheContainer().statistics(true);
        TestCacheManagerFactory.configureJmx((GlobalConfigurationBuilder)globalCfg, (String)this.jmxDomain(), (MBeanServerLookup)this.mBeanServerLookup);
        return TestCacheManagerFactory.createClusteredCacheManager((GlobalConfigurationBuilder)globalCfg, (ConfigurationBuilder)cfg);
    }

    public void testStats(Method m) {
        int bytesRead = 0;
        int bytesWritten = 0;
        Map<String, String> s = this.client().stats();
        AssertJUnit.assertEquals((String)s.get("currentNumberOfEntries"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("totalNumberOfEntries"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("stores"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("retrievals"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("hits"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("misses"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("removeHits"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("removeMisses"), (String)"0");
        bytesRead = this.assertHigherBytes(bytesRead, s.get("totalBytesRead"));
        AssertJUnit.assertEquals((String)s.get("totalBytesWritten"), (String)"0");
        this.client().assertPut(m);
        s = this.client().stats();
        AssertJUnit.assertEquals((String)s.get("currentNumberOfEntries"), (String)"1");
        AssertJUnit.assertEquals((String)s.get("totalNumberOfEntries"), (String)"1");
        AssertJUnit.assertEquals((String)s.get("stores"), (String)"1");
        bytesRead = this.assertHigherBytes(bytesRead, s.get("totalBytesRead"));
        bytesWritten = this.assertHigherBytes(bytesWritten, s.get("totalBytesWritten"));
        AssertJUnit.assertFalse((boolean)Objects.equals(s.get("totalBytesRead"), "0"));
        AssertJUnit.assertFalse((boolean)Objects.equals(s.get("totalBytesWritten"), "0"));
        HotRodTestingUtil.assertSuccess(this.client().assertGet(m), HotRodTestingUtil.v(m));
        s = this.client().stats();
        AssertJUnit.assertEquals((String)s.get("hits"), (String)"1");
        AssertJUnit.assertEquals((String)s.get("misses"), (String)"0");
        AssertJUnit.assertEquals((String)s.get("retrievals"), (String)"1");
        this.assertHigherBytes(bytesRead, s.get("totalBytesRead"));
        this.assertHigherBytes(bytesWritten, s.get("totalBytesWritten"));
        this.client().clear();
        s = this.client().stats();
        AssertJUnit.assertEquals((String)s.get("totalNumberOfEntries"), (String)"1");
        AssertJUnit.assertEquals((String)s.get("currentNumberOfEntries"), (String)"0");
    }

    private int assertHigherBytes(int currentBytesRead, String bytesStr) {
        int bytesRead = Integer.valueOf(bytesStr);
        AssertJUnit.assertTrue((String)String.format("Expecting %d > %d", bytesRead, currentBytesRead), (bytesRead > currentBytesRead ? 1 : 0) != 0);
        return bytesRead;
    }
}

