/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod;

import java.lang.reflect.Method;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.server.hotrod.FlagCheckCommandInterceptor;
import org.infinispan.server.hotrod.HotRodSingleNodeTest;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.ProtocolFlag;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="server.hotrod.SkipCacheLoadHotRodTest")
public class SkipCacheLoadHotRodTest
extends HotRodSingleNodeTest {
    private static final int SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE = SkipCacheLoadHotRodTest.join(ProtocolFlag.SkipCacheLoader.getValue(), ProtocolFlag.ForceReturnPreviousValue.getValue());

    public void testPut(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0), OperationStatus.Success);
        commandInterceptor.expectSkipLoadFlag = true;
        HotRodTestingUtil.assertStatus(this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.Success);
        HotRodTestingUtil.assertStatus(this.client().put(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.SuccessWithPrevious);
    }

    public void testReplace(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0), OperationStatus.OperationNotExecuted);
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.OperationNotExecuted);
        HotRodTestingUtil.assertStatus(this.client().replace(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.OperationNotExecuted);
    }

    public void testPutIfAbsent(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0), OperationStatus.Success);
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.OperationNotExecuted);
        HotRodTestingUtil.assertStatus(this.client().putIfAbsent(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.NotExecutedWithPrevious);
    }

    public void testReplaceIfUnmodified(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().replaceIfUnmodified(HotRodTestingUtil.k(m), 0, 0, HotRodTestingUtil.v(m), 0L, SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testGet(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().get(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipLoadFlag = true;
        HotRodTestingUtil.assertStatus(this.client().get(HotRodTestingUtil.k(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().get(HotRodTestingUtil.k(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testGetWithVersion(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().getWithVersion(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipLoadFlag = true;
        HotRodTestingUtil.assertStatus(this.client().getWithVersion(HotRodTestingUtil.k(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().getWithVersion(HotRodTestingUtil.k(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testGetWithMetadata(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().getWithMetadata(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipLoadFlag = true;
        HotRodTestingUtil.assertStatus(this.client().getWithMetadata(HotRodTestingUtil.k(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().getWithMetadata(HotRodTestingUtil.k(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testRemove(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().remove(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipLoadFlag = true;
        HotRodTestingUtil.assertStatus(this.client().remove(HotRodTestingUtil.k(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().remove(HotRodTestingUtil.k(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testRemoveIfUnmodified(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0L, 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0L, ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().removeIfUnmodified(HotRodTestingUtil.k(m), 0L, SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    public void testContainsKey(Method m) {
        FlagCheckCommandInterceptor commandInterceptor = this.init();
        commandInterceptor.expectSkipLoadFlag = false;
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), 0), OperationStatus.KeyDoesNotExist);
        commandInterceptor.expectSkipLoadFlag = true;
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), ProtocolFlag.SkipCacheLoader.getValue()), OperationStatus.KeyDoesNotExist);
        HotRodTestingUtil.assertStatus(this.client().containsKey(HotRodTestingUtil.k(m), SKIP_LOADER_AND_RETURN_PREVIOUS_VALUE), OperationStatus.KeyDoesNotExist);
    }

    private FlagCheckCommandInterceptor init() {
        AsyncInterceptorChain interceptorChain = this.cacheManager.getCache(this.cacheName).getAdvancedCache().getAsyncInterceptorChain();
        FlagCheckCommandInterceptor interceptor = (FlagCheckCommandInterceptor)interceptorChain.findInterceptorExtending(FlagCheckCommandInterceptor.class);
        if (interceptor != null) {
            return interceptor;
        }
        FlagCheckCommandInterceptor ci = new FlagCheckCommandInterceptor();
        interceptorChain.addInterceptor((AsyncInterceptor)ci, 1);
        return ci;
    }

    private static int join(int flagId, int joinId) {
        return joinId | flagId;
    }
}

