/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.counter.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import org.infinispan.commons.test.Exceptions;
import org.infinispan.counter.api.CounterConfiguration;
import org.infinispan.counter.api.CounterEvent;
import org.infinispan.counter.api.CounterListener;
import org.infinispan.counter.api.CounterManager;
import org.infinispan.counter.api.CounterState;
import org.infinispan.counter.api.CounterType;
import org.infinispan.counter.api.Handle;
import org.infinispan.counter.api.StrongCounter;
import org.infinispan.counter.exception.CounterOutOfBoundsException;
import org.infinispan.counter.impl.Util;
import org.infinispan.server.hotrod.counter.StrongCounterTestStrategy;
import org.infinispan.server.hotrod.counter.impl.BaseCounterImplTest;
import org.testng.AssertJUnit;

public class StrongCounterImplTestStrategy
extends BaseCounterImplTest<StrongCounter>
implements StrongCounterTestStrategy {
    private final Supplier<Collection<CounterManager>> allCounterManagerSupplier;

    public StrongCounterImplTestStrategy(Supplier<CounterManager> counterManagerSupplier, Supplier<Collection<CounterManager>> allCounterManagerSupplier) {
        super(counterManagerSupplier);
        this.allCounterManagerSupplier = allCounterManagerSupplier;
    }

    @Override
    public void testCompareAndSet(Method method) {
        String counterName = method.getName();
        CounterManager counterManager = (CounterManager)this.counterManagerSupplier.get();
        AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(2L).build()));
        StrongCounter counter = counterManager.getStrongCounter(counterName);
        AssertJUnit.assertFalse((boolean)((Boolean)Util.awaitCounterOperation((CompletableFuture)counter.compareAndSet(0L, 1L))));
        AssertJUnit.assertTrue((boolean)((Boolean)Util.awaitCounterOperation((CompletableFuture)counter.compareAndSet(2L, 3L))));
    }

    @Override
    public void testCompareAndSwap(Method method) {
        String counterName = method.getName();
        CounterManager counterManager = (CounterManager)this.counterManagerSupplier.get();
        AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(3L).build()));
        StrongCounter counter = counterManager.getStrongCounter(counterName);
        AssertJUnit.assertEquals((long)3L, (long)((Long)Util.awaitCounterOperation((CompletableFuture)counter.compareAndSwap(0L, 1L))));
        AssertJUnit.assertEquals((long)3L, (long)((Long)Util.awaitCounterOperation((CompletableFuture)counter.compareAndSwap(3L, 2L))));
    }

    @Override
    public void testBoundaries(Method method) {
        String counterName = method.getName();
        CounterManager counterManager = (CounterManager)this.counterManagerSupplier.get();
        AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(1L).lowerBound(0L).upperBound(20L).build()));
        StrongCounter counter = counterManager.getStrongCounter(counterName);
        this.assertCounterValue(counter, 1L);
        Exceptions.expectException(ExecutionException.class, CounterOutOfBoundsException.class, () -> counter.addAndGet(-10L).get());
        Exceptions.expectException(ExecutionException.class, CounterOutOfBoundsException.class, () -> counter.addAndGet(30L).get());
        this.assertCounterValue(counter, 20L);
        Exceptions.expectException(ExecutionException.class, CounterOutOfBoundsException.class, () -> counter.compareAndSet(20L, -1L).get());
        this.assertCounterValue(counter, 20L);
        Exceptions.expectException(ExecutionException.class, CounterOutOfBoundsException.class, () -> counter.compareAndSet(20L, 21L).get());
    }

    @Override
    public void testListenerWithBounds(Method method) throws InterruptedException {
        String counterName = method.getName();
        CounterManager counterManager = (CounterManager)this.counterManagerSupplier.get();
        AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(0L).lowerBound(0L).upperBound(20L).build()));
        StrongCounter counter = counterManager.getStrongCounter(counterName);
        Handle handle = counter.addListener((CounterListener)new BaseCounterImplTest.EventLogger());
        this.add(counter, 1L, 1L);
        Exceptions.expectException(ExecutionException.class, CounterOutOfBoundsException.class, () -> counter.addAndGet(20L).get());
        this.assertCounterValue(counter, 20L);
        this.reset(counter);
        Exceptions.expectException(CounterOutOfBoundsException.class, () -> this.add(counter, -1L, 0L));
        this.assertCounterValue(counter, 0L);
        StrongCounterImplTestStrategy.assertNextValidEvent((Handle<BaseCounterImplTest.EventLogger>)handle, 0L, 1L);
        this.assertNextEvent((Handle<BaseCounterImplTest.EventLogger>)handle, 1L, CounterState.VALID, 20L, CounterState.UPPER_BOUND_REACHED);
        this.assertNextEvent((Handle<BaseCounterImplTest.EventLogger>)handle, 20L, CounterState.UPPER_BOUND_REACHED, 0L, CounterState.VALID);
        this.assertNextEvent((Handle<BaseCounterImplTest.EventLogger>)handle, 0L, CounterState.VALID, 0L, CounterState.LOWER_BOUND_REACHED);
        StrongCounterImplTestStrategy.assertNoEvents((Handle<BaseCounterImplTest.EventLogger>)handle);
        handle.remove();
    }

    @Override
    public <L extends CounterListener> Handle<L> addListenerTo(StrongCounter counter, L logger) {
        return counter.addListener(logger);
    }

    @Override
    public StrongCounter defineAndCreateCounter(String counterName, long initialValue) {
        CounterManager counterManager = (CounterManager)this.counterManagerSupplier.get();
        AssertJUnit.assertTrue((boolean)counterManager.defineCounter(counterName, CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(initialValue).build()));
        return counterManager.getStrongCounter(counterName);
    }

    @Override
    public void add(StrongCounter counter, long delta, long result) {
        if (delta == 1L) {
            AssertJUnit.assertEquals((long)result, (long)((Long)Util.awaitCounterOperation((CompletableFuture)counter.incrementAndGet())));
        } else if (delta == -1L) {
            AssertJUnit.assertEquals((long)result, (long)((Long)Util.awaitCounterOperation((CompletableFuture)counter.decrementAndGet())));
        } else {
            AssertJUnit.assertEquals((long)result, (long)((Long)Util.awaitCounterOperation((CompletableFuture)counter.addAndGet(delta))));
        }
    }

    @Override
    void remove(StrongCounter counter) {
        Util.awaitCounterOperation((CompletableFuture)counter.remove());
    }

    @Override
    void assertCounterValue(StrongCounter counter, long value) {
        AssertJUnit.assertEquals((long)value, (long)((Long)Util.awaitCounterOperation((CompletableFuture)counter.getValue())));
    }

    @Override
    void reset(StrongCounter counter) {
        Util.awaitCounterOperation((CompletableFuture)counter.reset());
    }

    @Override
    List<CounterConfiguration> configurationsToTest() {
        return Arrays.asList(CounterConfiguration.builder((CounterType)CounterType.UNBOUNDED_STRONG).initialValue(5L).build(), CounterConfiguration.builder((CounterType)CounterType.BOUNDED_STRONG).initialValue(0L).lowerBound(-1L).upperBound(1L).build());
    }

    @Override
    void assertCounterNameAndConfiguration(String counterName, CounterConfiguration configuration) {
        this.allCounterManagerSupplier.get().forEach(counterManager -> {
            StrongCounter counter = counterManager.getStrongCounter(counterName);
            AssertJUnit.assertEquals((String)counterName, (String)counter.getName());
            AssertJUnit.assertEquals((Object)configuration, (Object)counter.getConfiguration());
        });
    }

    private void assertNextEvent(Handle<BaseCounterImplTest.EventLogger> handle, long oldValue, CounterState oldState, long newValue, CounterState newState) throws InterruptedException {
        CounterEvent event = ((BaseCounterImplTest.EventLogger)handle.getCounterListener()).waitingPoll();
        AssertJUnit.assertNotNull((Object)event);
        AssertJUnit.assertEquals((long)oldValue, (long)event.getOldValue());
        AssertJUnit.assertEquals((Object)oldState, (Object)event.getOldState());
        AssertJUnit.assertEquals((long)newValue, (long)event.getNewValue());
        AssertJUnit.assertEquals((Object)newState, (Object)event.getNewState());
    }
}

